/*
 * Copyright 2015 David Russell
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.onetapbeyond.renjin.r.executor;

import org.renjin.sexp.SEXP;

/**
 * Executable R task result data. Generated by a call on 
 * {@link RenjinTask#execute}. A result instance can be queried
 * to determine success or failure of a task execution.
 * On success, the task result data is made available
 * by the {@link RenjinResult#data} method. On failure,
 * the cause of the failure can be determined by querying
 * the {@link RenjinResult#error} and
 * {@link RenjinResult#cause} methods respecitvely.
 */
public interface RenjinResult extends java.io.Serializable {

	/**
	 * Returns status of task execution.
	 * @return true if the task execution was successful, otherwise false
	 */
	public boolean success();

	/**
	 * Returns error message on task execution failure.
	 * @return error message on task execution failure, otherwise null
	 */
	public String error();

	/**
	 * Returns cause of error on task execution failure.
	 * @return cause of error on task execution failure, otherwise null
	 */
	public Throwable cause();

	/**
	 * Returns approximate time taken (ms) by task execution.
	 * @return time taken (ms) on task execution success, otherwise zero
	 */
	public long timeTaken();

	/**
	 * Returns task execution result data.
	 * @return  result data on task execution success, otherwise null
	 */
	public SEXP data();

}
