/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import com.google.common.base.Preconditions;
import redis.embedded.util.Architecture;
import redis.embedded.util.OS;
import redis.embedded.util.OSDetector;

public class OsArchitecture {
    public static final OsArchitecture UNIX_x86 = new OsArchitecture(OS.UNIX, Architecture.x86);
    public static final OsArchitecture UNIX_x86_64 = new OsArchitecture(OS.UNIX, Architecture.x86_64);
    public static final OsArchitecture UNIX_arm64 = new OsArchitecture(OS.UNIX, Architecture.arm64);
    public static final OsArchitecture MAC_OS_X_x86_64 = new OsArchitecture(OS.MAC_OS_X, Architecture.x86_64);
    public static final OsArchitecture MAC_OS_X_arm64 = new OsArchitecture(OS.MAC_OS_X, Architecture.arm64);
    private final OS os;
    private final Architecture arch;

    public static OsArchitecture detect() {
        OS os = OSDetector.getOS();
        Architecture arch = OSDetector.getArchitecture();
        return new OsArchitecture(os, arch);
    }

    public OsArchitecture(OS os, Architecture arch) {
        Preconditions.checkNotNull((Object)((Object)os));
        Preconditions.checkNotNull((Object)((Object)arch));
        this.os = os;
        this.arch = arch;
    }

    public OS os() {
        return this.os;
    }

    public Architecture arch() {
        return this.arch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OsArchitecture that = (OsArchitecture)o;
        return this.arch == that.arch && this.os == that.os;
    }

    public int hashCode() {
        int result = this.os.hashCode();
        result = 31 * result + this.arch.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s (%s)", this.os.name(), this.arch.name());
    }
}

