/*
 * Decompiled with CFR 0.152.
 */
package io.oddsource.java.maven.profile;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;

public final class Utilities {
    private Utilities() {
    }

    public static Pattern getPattern(ActivationProperty activationProperty, ModelProblemCollector modelProblemCollector) {
        return Utilities.getPattern(activationProperty, modelProblemCollector, 0);
    }

    public static Pattern getPattern(ActivationProperty activationProperty, ModelProblemCollector modelProblemCollector, int n) {
        String string = activationProperty.getValue();
        try {
            return Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Utilities.problem(modelProblemCollector, activationProperty, "The property 'value' ('" + string + "') could not be compiled to a regular expression.");
            return null;
        }
    }

    public static List<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Character c = null;
        char c2 = '\u0000';
        for (char c3 : string.toCharArray()) {
            if (c != null && c.equals(Character.valueOf(c3))) {
                if (c2 == '\\') {
                    stringBuilder.setCharAt(stringBuilder.length() - 1, c3);
                } else {
                    c = null;
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            } else if (c == null && (c3 == '\"' || c3 == '\'') && c2 != '\\') {
                c = Character.valueOf(c3);
            } else if (c == null && c3 == ' ') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            } else {
                stringBuilder.append(c3);
            }
            c2 = c3;
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static boolean problem(ModelProblemCollector modelProblemCollector, ActivationProperty activationProperty, String string) {
        modelProblemCollector.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage(string).setLocation(activationProperty.getLocation((Object)"")));
        return false;
    }

    public static class CharsetAndRemainder {
        private static final Pattern PATTERN = Pattern.compile("^(?:\\[(?<charset>[a-zA-Z0-9_-]+)])?(?<remainder>.+)$");
        private final Charset charset;
        private final String remainder;

        public CharsetAndRemainder(String string, Charset charset, ActivationProperty activationProperty, ModelProblemCollector modelProblemCollector) {
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group("charset");
                if (string2 == null) {
                    this.charset = charset;
                } else {
                    Charset charset2 = null;
                    try {
                        charset2 = Charset.forName(string2);
                    }
                    catch (UnsupportedCharsetException unsupportedCharsetException) {
                        Utilities.problem(modelProblemCollector, activationProperty, "The charset from the property 'name' ('" + string + "') is not supported.");
                    }
                    this.charset = charset2;
                }
                this.remainder = matcher.group("remainder");
            } else {
                Utilities.problem(modelProblemCollector, activationProperty, "The property 'name' ('" + string + "') did not match the optional charset extraction pattern.");
                this.charset = null;
                this.remainder = null;
            }
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getRemainder() {
            return this.remainder;
        }
    }
}

