/*
 * Decompiled with CFR 0.152.
 */
package io.oddsource.java.maven.profile;

import io.oddsource.java.maven.profile.FinerActivator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.codehaus.plexus.logging.Logger;

@Named(value="default")
@Singleton
public class FinerProfileSelector
extends DefaultProfileSelector {
    private static final Pattern ACTIVATOR_PATTERN = Pattern.compile("^\\[FINER\\.ACTIVATOR\\.(?<activator>[A-Z0-9.]+)](?<property>.*)$");
    private final Logger logger;
    private final List<ProfileActivator> standardActivators = new ArrayList<ProfileActivator>();
    private final List<FinerActivator> finerActivators = new ArrayList<FinerActivator>();

    @Inject
    public FinerProfileSelector(Logger logger, List<ProfileActivator> list, List<FinerActivator> list2) {
        this.logger = logger;
        this.standardActivators.addAll(list);
        this.finerActivators.addAll(list2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("FinerProfileSelector constructed with " + list.size() + " standard activators and" + list2.size() + " finer activators.");
        }
    }

    public List<Profile> getActiveProfiles(Collection<Profile> collection, ProfileActivationContext profileActivationContext, ModelProblemCollector modelProblemCollector) {
        List<Profile> list = this.getSupersActiveProfiles(collection, profileActivationContext, modelProblemCollector);
        HashSet hashSet = new HashSet(list.size());
        list.forEach(profile -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Profile " + profile.getId() + " activated by DefaultProfileSelector.");
            }
            hashSet.add(profile.getId());
        });
        for (Profile profile2 : collection) {
            if (hashSet.contains(profile2.getId())) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Checking inactive profile " + profile2.getId() + " for activatability.");
            }
            if (!this.isActive(profile2, profileActivationContext, modelProblemCollector)) continue;
            list.add(profile2);
        }
        if (this.logger.isDebugEnabled() && !list.isEmpty()) {
            this.logger.info("Activator selected profiles: " + Arrays.toString(list.toArray()));
        }
        return list;
    }

    protected List<Profile> getSupersActiveProfiles(Collection<Profile> collection, ProfileActivationContext profileActivationContext, ModelProblemCollector modelProblemCollector) {
        return super.getActiveProfiles(collection, profileActivationContext, modelProblemCollector);
    }

    private boolean isActive(Profile profile, ProfileActivationContext profileActivationContext, ModelProblemCollector modelProblemCollector) {
        int n = 0;
        int n2 = 0;
        for (ProfileActivator profileActivator : this.standardActivators) {
            if (!profileActivator.presentInConfig(profile, profileActivationContext, modelProblemCollector)) continue;
            ++n;
            boolean bl = profileActivator.isActive(profile, profileActivationContext, modelProblemCollector);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Standard activator " + profileActivator + " " + this.activeInactive(bl));
            }
            if (bl) {
                ++n2;
                continue;
            }
            if (!(profileActivator instanceof PropertyProfileActivator) || !this.isFinerActive(profile, profileActivationContext, modelProblemCollector)) continue;
            ++n2;
        }
        return n2 > 0 && n2 == n;
    }

    private boolean isFinerActive(Profile profile, ProfileActivationContext profileActivationContext, ModelProblemCollector modelProblemCollector) {
        ActivationProperty activationProperty = profile.getActivation().getProperty();
        String string = activationProperty.getName();
        if (string == null) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        Matcher matcher = ACTIVATOR_PATTERN.matcher(string);
        if (matcher.matches()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Property name '" + string + "' matches finer activator pattern.");
            }
            for (FinerActivator finerActivator : this.finerActivators) {
                boolean bl;
                boolean bl2 = finerActivator.getSupportedActivatorBracketName().equals(matcher.group("activator"));
                boolean bl3 = bl = bl2 && finerActivator.isActive(matcher.group("property"), activationProperty, profile, profileActivationContext, modelProblemCollector);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(finerActivator + " applicable to property name '" + string + "' = " + bl2);
                    this.logger.debug(finerActivator + " " + this.activeInactive(bl));
                }
                if (bl2) {
                    ++n;
                }
                if (!bl) continue;
                ++n2;
            }
        }
        return n2 > 0 && n2 == n;
    }

    private String activeInactive(boolean bl) {
        return bl ? "ACTIVE" : "INACTIVE";
    }
}

