/*
 * Decompiled with CFR 0.152.
 */
package io.oddsource.java.maven.profile;

import io.oddsource.java.maven.profile.BaseFinerActivator;
import io.oddsource.java.maven.profile.Utilities;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.codehaus.plexus.logging.Logger;

public abstract class BaseFileContentsActivator
extends BaseFinerActivator {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String PRELUDE = "The file named by the property 'name' ('";
    private final Logger logger;

    protected BaseFileContentsActivator(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isActive(String string, ActivationProperty activationProperty, Profile profile, ProfileActivationContext profileActivationContext, ModelProblemCollector modelProblemCollector) {
        String string2;
        Utilities.CharsetAndRemainder charsetAndRemainder = new Utilities.CharsetAndRemainder(string, DEFAULT_CHARSET, activationProperty, modelProblemCollector);
        Charset charset = charsetAndRemainder.getCharset();
        String string3 = charsetAndRemainder.getRemainder();
        if (charset == null || string3 == null) {
            this.logger.debug("BaseFileContentsActivator: charset == null || filename == null");
            return false;
        }
        File file = this.getAbsoluteFile(string3, activationProperty, modelProblemCollector);
        if (file == null || !file.exists()) {
            this.logger.debug("BaseFileContentsActivator(" + string3 + "): file == null || !file.exists()");
            return false;
        }
        try {
            string2 = new String(Files.readAllBytes(file.toPath()), charset);
        }
        catch (IOException | SecurityException | InvalidPathException exception) {
            return Utilities.problem(modelProblemCollector, activationProperty, PRELUDE + string3 + "') exists but could not be read.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("BaseFileContentsActivator: contents of file " + string3 + " = " + string2);
        }
        return this.contentsMatch(string2, activationProperty, modelProblemCollector);
    }

    private File getAbsoluteFile(String string, ActivationProperty activationProperty, ModelProblemCollector modelProblemCollector) {
        try {
            return new File(string).getAbsoluteFile();
        }
        catch (SecurityException securityException) {
            Utilities.problem(modelProblemCollector, activationProperty, PRELUDE + string + "') is not accessible.");
            return null;
        }
    }

    protected abstract boolean contentsMatch(String var1, ActivationProperty var2, ModelProblemCollector var3);
}

