/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.ocfl.api.exception.InvalidVersionException;
import io.ocfl.api.util.Enforce;
import java.util.regex.Pattern;

public class VersionNum
implements Comparable<VersionNum> {
    public static final VersionNum V1 = new VersionNum(1L);
    private static final Pattern VALID_VERSION = Pattern.compile("^v\\d+$");
    private final long versionNumber;
    private final int zeroPaddingWidth;
    private final long maxVersion;
    private final String stringValue;

    @JsonCreator
    public static VersionNum fromString(String value) {
        if (!VALID_VERSION.matcher(value).matches()) {
            throw new InvalidVersionException("Invalid VersionNum: " + value);
        }
        String numPart = value.substring(1);
        int padding = 0;
        if (!numPart.equals("0") && numPart.startsWith("0")) {
            padding = numPart.length();
        }
        return new VersionNum(Long.parseLong(numPart), padding);
    }

    public static VersionNum fromInt(int versionNumber) {
        return new VersionNum(versionNumber);
    }

    public VersionNum(long versionNumber) {
        this(versionNumber, 0);
    }

    public VersionNum(long versionNumber, int zeroPaddingWidth) {
        this.versionNumber = Enforce.expressionTrue(versionNumber >= 0L, versionNumber, "versionNumber must be greater than or equal to 0");
        this.zeroPaddingWidth = Enforce.expressionTrue(zeroPaddingWidth >= 0, zeroPaddingWidth, "zeroPaddingWidth must be greater than or equal to 0");
        this.stringValue = zeroPaddingWidth == 0 ? "v" + versionNumber : String.format("v%0" + zeroPaddingWidth + "d", versionNumber);
        this.maxVersion = zeroPaddingWidth == 0 ? Long.MAX_VALUE : (long)Math.pow(10.0, zeroPaddingWidth - 1) - 1L;
    }

    public VersionNum nextVersionNum() {
        long nextVersionNum = this.versionNumber + 1L;
        if (nextVersionNum > this.maxVersion) {
            throw new InvalidVersionException("Cannot increment version number. Current version " + this + " is the highest possible.");
        }
        return new VersionNum(nextVersionNum, this.zeroPaddingWidth);
    }

    public VersionNum previousVersionNum() {
        if (this.versionNumber == 1L) {
            throw new InvalidVersionException("Cannot decrement version number. Current version " + this + " is the lowest possible.");
        }
        return new VersionNum(this.versionNumber - 1L, this.zeroPaddingWidth);
    }

    public int getZeroPaddingWidth() {
        return this.zeroPaddingWidth;
    }

    public long getVersionNum() {
        return this.versionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionNum versionNum = (VersionNum)o;
        return this.versionNumber == versionNum.versionNumber;
    }

    public int hashCode() {
        return Long.hashCode(this.versionNumber);
    }

    @JsonValue
    public String toString() {
        return this.stringValue;
    }

    @Override
    public int compareTo(VersionNum o) {
        return Long.compare(this.versionNumber, o.versionNumber);
    }
}

