/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.ocfl.api.model.FileDetails;
import io.ocfl.api.model.ObjectVersionId;
import io.ocfl.api.model.OcflVersion;
import io.ocfl.api.model.VersionInfo;
import io.ocfl.api.model.VersionNum;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VersionDetails {
    private ObjectVersionId objectVersionId;
    private OcflVersion objectOcflVersion;
    private OffsetDateTime created;
    private VersionInfo versionInfo;
    private boolean mutable;
    private Map<String, FileDetails> fileMap = new HashMap<String, FileDetails>();

    public ObjectVersionId getObjectVersionId() {
        return this.objectVersionId;
    }

    public VersionDetails setObjectVersionId(ObjectVersionId objectVersionId) {
        this.objectVersionId = objectVersionId;
        return this;
    }

    @JsonIgnore
    public String getObjectId() {
        return this.objectVersionId.getObjectId();
    }

    @JsonIgnore
    public VersionNum getVersionNum() {
        return this.objectVersionId.getVersionNum();
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public VersionDetails setCreated(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public VersionDetails setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
        return this;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public VersionDetails setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public OcflVersion getObjectOcflVersion() {
        return this.objectOcflVersion;
    }

    public VersionDetails setObjectOcflVersion(OcflVersion objectOcflVersion) {
        this.objectOcflVersion = objectOcflVersion;
        return this;
    }

    @JsonIgnore
    public Collection<FileDetails> getFiles() {
        return this.fileMap.values();
    }

    public boolean containsFile(String path) {
        return this.fileMap.containsKey(path);
    }

    public FileDetails getFile(String path) {
        return this.fileMap.get(path);
    }

    public VersionDetails setFileMap(Map<String, FileDetails> fileMap) {
        this.fileMap = fileMap;
        return this;
    }

    public Map<String, FileDetails> getFileMap() {
        return this.fileMap;
    }

    public String toString() {
        return "VersionDetails{objectVersionId=" + this.objectVersionId + ", objectOcflVersion=" + this.objectOcflVersion + ", created=" + this.created + ", versionInfo=" + this.versionInfo + ", mutable=" + this.mutable + ", fileMap=" + this.fileMap + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionDetails that = (VersionDetails)o;
        return this.mutable == that.mutable && Objects.equals(this.objectVersionId, that.objectVersionId) && this.objectOcflVersion == that.objectOcflVersion && Objects.equals(this.created, that.created) && Objects.equals(this.versionInfo, that.versionInfo) && Objects.equals(this.fileMap, that.fileMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.objectVersionId, this.objectOcflVersion, this.created, this.versionInfo, this.mutable, this.fileMap});
    }
}

