/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.io;

import at.favre.lib.bytes.Bytes;
import io.ocfl.api.exception.FixityCheckException;
import io.ocfl.api.exception.OcflJavaException;
import io.ocfl.api.model.DigestAlgorithm;
import io.ocfl.api.util.Enforce;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;

public class FixityCheckInputStream
extends DigestInputStream {
    private boolean enabled = true;
    private final String expectedDigestValue;
    private String actualDigestValue;

    public FixityCheckInputStream(InputStream inputStream, DigestAlgorithm digestAlgorithm, String expectedDigestValue) {
        super(inputStream, digestAlgorithm.getMessageDigest());
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public FixityCheckInputStream(InputStream inputStream, String digestAlgorithm, String expectedDigestValue) {
        super(inputStream, FixityCheckInputStream.messageDigest(digestAlgorithm));
        this.expectedDigestValue = Enforce.notBlank(expectedDigestValue, "expectedDigestValue cannot be blank");
    }

    public void checkFixity() {
        String actualDigest;
        if (this.enabled && !this.expectedDigestValue.equalsIgnoreCase(actualDigest = this.getActualDigestValue().get())) {
            throw new FixityCheckException(String.format("Expected %s digest: %s; Actual: %s", this.digest.getAlgorithm(), this.expectedDigestValue, actualDigest));
        }
    }

    public String getExpectedDigestValue() {
        return this.expectedDigestValue;
    }

    public Optional<String> getActualDigestValue() {
        if (this.enabled && this.actualDigestValue == null) {
            this.actualDigestValue = Bytes.wrap((byte[])this.digest.digest()).encodeHex();
        }
        return Optional.of(this.actualDigestValue);
    }

    public FixityCheckInputStream enableFixityCheck(boolean enabled) {
        this.on(enabled);
        return this;
    }

    @Override
    public void on(boolean on) {
        this.enabled = on;
        super.on(on);
    }

    @Override
    public String toString() {
        return "[Fixity Check Input Stream] expected: " + this.expectedDigestValue + "; actual: " + this.digest.toString();
    }

    private static MessageDigest messageDigest(String digestAlgorithm) {
        try {
            return MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OcflJavaException(e);
        }
    }
}

