/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api;

import io.ocfl.api.OcflConstants;
import io.ocfl.api.model.DigestAlgorithm;
import io.ocfl.api.model.OcflVersion;
import io.ocfl.api.util.Enforce;
import java.util.regex.Pattern;

public class OcflConfig {
    private OcflVersion ocflVersion;
    private DigestAlgorithm defaultDigestAlgorithm;
    private String defaultContentDirectory;
    private int defaultZeroPaddingWidth;
    private boolean upgradeObjectsOnWrite;

    public OcflConfig() {
        this.ocflVersion = null;
        this.defaultDigestAlgorithm = OcflConstants.DEFAULT_DIGEST_ALGORITHM;
        this.defaultContentDirectory = "content";
        this.defaultZeroPaddingWidth = 0;
        this.upgradeObjectsOnWrite = false;
    }

    public OcflConfig(OcflConfig original) {
        this.ocflVersion = original.ocflVersion;
        this.defaultDigestAlgorithm = original.defaultDigestAlgorithm;
        this.defaultContentDirectory = original.defaultContentDirectory;
        this.defaultZeroPaddingWidth = original.defaultZeroPaddingWidth;
        this.upgradeObjectsOnWrite = original.upgradeObjectsOnWrite;
    }

    public OcflConfig setOcflVersion(OcflVersion ocflVersion) {
        this.ocflVersion = ocflVersion;
        return this;
    }

    public OcflVersion getOcflVersion() {
        return this.ocflVersion;
    }

    public OcflConfig setDefaultDigestAlgorithm(DigestAlgorithm defaultDigestAlgorithm) {
        Enforce.notNull(defaultDigestAlgorithm, "defaultDigestAlgorithm cannot be null");
        this.defaultDigestAlgorithm = Enforce.expressionTrue(OcflConstants.ALLOWED_DIGEST_ALGORITHMS.contains(defaultDigestAlgorithm), defaultDigestAlgorithm, "Digest algorithm must be one of: " + OcflConstants.ALLOWED_DIGEST_ALGORITHMS);
        return this;
    }

    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public OcflConfig setDefaultContentDirectory(String defaultContentDirectory) {
        Enforce.notBlank(defaultContentDirectory, "contentDirectory cannot be blank");
        this.defaultContentDirectory = Enforce.expressionTrue(!Pattern.matches(".*[/\\\\].*", defaultContentDirectory), defaultContentDirectory, "Content directory cannot contain / or \\");
        return this;
    }

    public String getDefaultContentDirectory() {
        return this.defaultContentDirectory;
    }

    public int getDefaultZeroPaddingWidth() {
        return this.defaultZeroPaddingWidth;
    }

    public OcflConfig setDefaultZeroPaddingWidth(int defaultZeroPaddingWidth) {
        this.defaultZeroPaddingWidth = defaultZeroPaddingWidth;
        return this;
    }

    public boolean isUpgradeObjectsOnWrite() {
        return this.upgradeObjectsOnWrite;
    }

    public OcflConfig setUpgradeObjectsOnWrite(boolean upgradeObjectsOnWrite) {
        this.upgradeObjectsOnWrite = upgradeObjectsOnWrite;
        return this;
    }

    public String toString() {
        return "OcflConfig{ocflVersion=" + this.ocflVersion + ", defaultDigestAlgorithm=" + this.defaultDigestAlgorithm + ", defaultContentDirectory='" + this.defaultContentDirectory + "', defaultZeroPaddingWidth=" + this.defaultZeroPaddingWidth + ", upgradeObjectsOnWrite=" + this.upgradeObjectsOnWrite + "}";
    }
}

