/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.ocfl.api.exception.InvalidVersionException;
import io.ocfl.api.model.VersionNum;
import io.ocfl.api.util.Enforce;
import java.util.Objects;

public class ObjectVersionId {
    private final String objectId;
    private final VersionNum versionNum;

    public static ObjectVersionId head(String objectId) {
        return new ObjectVersionId(objectId);
    }

    public static ObjectVersionId version(String objectId, String versionNum) {
        if (versionNum == null) {
            return new ObjectVersionId(objectId, null);
        }
        return new ObjectVersionId(objectId, VersionNum.fromString(versionNum));
    }

    public static ObjectVersionId version(String objectId, int versionNum) {
        return new ObjectVersionId(objectId, VersionNum.fromInt(versionNum));
    }

    @JsonCreator
    public static ObjectVersionId version(@JsonProperty(value="objectId") String objectId, @JsonProperty(value="versionNum") VersionNum versionNum) {
        return new ObjectVersionId(objectId, versionNum);
    }

    private ObjectVersionId(String objectId) {
        this(objectId, null);
    }

    private ObjectVersionId(String objectId, VersionNum versionNum) {
        this.objectId = Enforce.notBlank(objectId, "objectId cannot be blank");
        this.versionNum = versionNum;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public VersionNum getVersionNum() {
        return this.versionNum;
    }

    @JsonIgnore
    public boolean isHead() {
        return this.versionNum == null;
    }

    public ObjectVersionId nextVersion() {
        if (this.versionNum == null) {
            throw new InvalidVersionException("Cannot resolve next version number because the current version number is not set.");
        }
        return ObjectVersionId.version(this.objectId, this.versionNum.nextVersionNum());
    }

    public ObjectVersionId previousVersion() {
        if (this.versionNum == null) {
            throw new InvalidVersionException("Cannot resolve previous version number because the current version number is not set.");
        }
        return ObjectVersionId.version(this.objectId, this.versionNum.previousVersionNum());
    }

    public String toString() {
        return "ObjectId{objectId='" + this.objectId + "', versionNum='" + this.versionNum + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectVersionId that = (ObjectVersionId)o;
        return this.objectId.equals(that.objectId) && this.versionNum.equals(that.versionNum);
    }

    public int hashCode() {
        return Objects.hash(this.objectId, this.versionNum);
    }
}

