/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.ocfl.api.exception.OcflJavaException;
import io.ocfl.api.model.OcflVersion;

public enum InventoryType {
    OCFL_1_0("https://ocfl.io/1.0/spec/#inventory"),
    OCFL_1_1("https://ocfl.io/1.1/spec/#inventory");

    private final String id;

    private InventoryType(String id) {
        this.id = id;
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public OcflVersion getOcflVersion() {
        switch (this) {
            case OCFL_1_0: {
                return OcflVersion.OCFL_1_0;
            }
            case OCFL_1_1: {
                return OcflVersion.OCFL_1_1;
            }
        }
        throw new OcflJavaException("Unmapped inventory type " + this.id);
    }

    @JsonCreator
    public static InventoryType fromValue(String value) {
        for (InventoryType entry : InventoryType.values()) {
            if (!entry.id.equalsIgnoreCase(value)) continue;
            return entry;
        }
        throw new OcflJavaException("Unknown InventoryType: " + value);
    }
}

