/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.exception;

import io.ocfl.api.exception.OcflFileAlreadyExistsException;
import io.ocfl.api.exception.OcflJavaException;
import io.ocfl.api.exception.OcflNoSuchFileException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;

public class OcflIOException
extends OcflJavaException {
    private final Exception cause;
    private final boolean hasMessage;

    public static OcflIOException from(IOException e) {
        if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
            return new OcflNoSuchFileException(e);
        }
        if (e instanceof FileAlreadyExistsException) {
            return new OcflFileAlreadyExistsException(e);
        }
        return new OcflIOException(e);
    }

    public OcflIOException(Exception cause) {
        super(cause);
        this.cause = cause;
        this.hasMessage = false;
    }

    public OcflIOException(String message, Exception cause) {
        super(message, cause);
        this.cause = cause;
        this.hasMessage = true;
    }

    public OcflIOException(String message) {
        super(message);
        this.cause = null;
        this.hasMessage = true;
    }

    @Override
    public String getMessage() {
        if (this.hasMessage || this.cause == null) {
            return super.getMessage();
        }
        return this.cause.getClass().getSimpleName() + ": " + this.cause.getMessage();
    }
}

