/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.plugin.web;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import io.nuun.kernel.api.Kernel;
import io.nuun.kernel.api.config.KernelConfiguration;
import io.nuun.kernel.core.NuunCore;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuunServletContextListener
extends GuiceServletContextListener {
    private Logger logger = LoggerFactory.getLogger(NuunServletContextListener.class);
    private ServletContext servletContext;
    private Kernel kernel;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.servletContext = servletContextEvent.getServletContext();
        super.contextInitialized(servletContextEvent);
    }

    protected Injector getInjector() {
        ArrayList<String> params = new ArrayList<String>();
        Enumeration initparams = this.servletContext.getInitParameterNames();
        while (initparams.hasMoreElements()) {
            String keyName = (String)initparams.nextElement();
            if (keyName == null || keyName.isEmpty()) continue;
            String value = this.servletContext.getInitParameter(keyName);
            this.logger.info("Adding {}={} to NuunServletContextListener.", (Object)keyName, (Object)value);
            params.add(keyName);
            params.add(value);
        }
        String[] paramsArray = new String[params.size()];
        params.toArray(paramsArray);
        this.kernel = NuunCore.createKernel((KernelConfiguration)NuunCore.newKernelConfiguration().containerContext((Object)this.servletContext));
        this.kernel.init();
        this.kernel.start();
        return (Injector)this.kernel.objectGraph().as(Injector.class);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.kernel != null && this.kernel.isStarted()) {
            this.kernel.stop();
        }
        super.contextDestroyed(servletContextEvent);
    }
}

