/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.plugin.log;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.nuun.kernel.api.assertions.AssertUtils;
import io.nuun.plugin.log.NuunLog;
import io.nuun.plugin.log.SLF4JMembersInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;

public class SLF4JTypeListener
implements TypeListener {
    public <T> void hear(TypeLiteral<T> typeLiteral, TypeEncounter<T> typeEncounter) {
        for (Class c = typeLiteral.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : typeLiteral.getRawType().getDeclaredFields()) {
                if (field.getType() != Logger.class || !this.annotationPresent(field, NuunLog.class)) continue;
                typeEncounter.register(new SLF4JMembersInjector(field));
            }
        }
    }

    private boolean annotationPresent(Field field, Class<? extends Annotation> annoClass) {
        for (Annotation anno : field.getAnnotations()) {
            if (!AssertUtils.hasAnnotationDeep(anno.annotationType(), annoClass)) continue;
            return true;
        }
        return false;
    }
}

