/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.plugin.configuration.props;

import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import io.nuun.kernel.api.assertions.AssertUtils;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.spi.configuration.NuunProperty;
import io.nuun.plugin.configuration.props.PropsConfigurationMembersInjector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import jodd.props.Props;

public class PropsConfigurationTypeListener
implements TypeListener {
    private final Props props;

    @Inject
    public PropsConfigurationTypeListener(Props configuration) {
        this.props = configuration;
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        for (Class c = type.getRawType(); c != Object.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Holder h = new Holder();
                if (!this.annotationPresent(field, NuunProperty.class, h)) continue;
                if (AssertUtils.isEquivalent(NuunProperty.class, h.annotation.annotationType())) {
                    encounter.register(new PropsConfigurationMembersInjector(field, this.props, h.annotation));
                    continue;
                }
                throw new PluginException("Annotation class %s is not compatible with %s. Please check it.", new Object[]{h.annotation.annotationType().getCanonicalName(), NuunProperty.class.getCanonicalName()});
            }
        }
    }

    private boolean annotationPresent(Field field, Class<? extends Annotation> annoClass, Holder h) {
        for (Annotation anno : field.getAnnotations()) {
            if (!AssertUtils.hasAnnotationDeep(anno.annotationType(), annoClass)) continue;
            h.annotation = anno;
            return true;
        }
        return false;
    }

    static class Holder {
        public Annotation annotation;

        Holder() {
        }
    }
}

