/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.plugin.configuration.props;

import com.google.common.collect.Sets;
import com.google.inject.Module;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.core.AbstractPlugin;
import io.nuun.kernel.spi.configuration.NuunBaseConfigurationPlugin;
import io.nuun.plugin.configuration.props.PropsConfigurationGuiceModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import jodd.props.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsConfigurationPlugin
extends AbstractPlugin
implements NuunBaseConfigurationPlugin {
    Logger logger = LoggerFactory.getLogger(PropsConfigurationPlugin.class);
    private String PROPS_REGEX = ".*\\.props";
    private Module module = null;
    private Props props = null;

    public void addConfiguration(Map<String, Object> configuration) {
        Properties p = new Properties();
        p.putAll(configuration);
        this.props.load(p);
    }

    public Object getConfiguration() {
        return this.props;
    }

    public String name() {
        return "nuun-props-configuration-plugin";
    }

    public Object nativeUnitModule() {
        if (this.module == null) {
            this.module = new PropsConfigurationGuiceModule(this.props);
        }
        return this.module;
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return this.classpathScanRequestBuilder().resourcesRegex(this.PROPS_REGEX).build();
    }

    public InitState init(InitContext initContext) {
        HashSet allProperties = Sets.newHashSet();
        Collection propertiesFiles = initContext.propertiesFiles();
        allProperties.addAll(propertiesFiles);
        Map mapResourcesByRegex = initContext.mapResourcesByRegex();
        Collection propsFiles = (Collection)mapResourcesByRegex.get(this.PROPS_REGEX);
        allProperties.addAll(propsFiles);
        this.props = new Props();
        for (String propertiesFile : allProperties) {
            this.logger.info("adding {} to configuration", (Object)propertiesFile);
            try {
                InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertiesFile);
                this.props.load(resourceAsStream);
            }
            catch (IOException e) {
                throw new PluginException("Error When loading properties file " + propertiesFile, new Object[0]);
            }
        }
        return InitState.INITIALIZED;
    }
}

