/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.plugin.configuration.props;

import com.google.inject.MembersInjector;
import io.nuun.kernel.api.assertions.AssertUtils;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.spi.configuration.NuunProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import jodd.props.Props;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropsConfigurationMembersInjector<T>
implements MembersInjector<T> {
    private static final String NO_PROPERTY_FOUND_LOG_MESSAGE = "No property {} found. Injecting default value";
    private static final Logger log = LoggerFactory.getLogger(PropsConfigurationMembersInjector.class);
    private final Field field;
    private final Props props;
    private Annotation clonedAnno;

    public PropsConfigurationMembersInjector(Field field, Props props, Annotation clonedAnno) {
        this.field = field;
        this.props = props;
        this.clonedAnno = clonedAnno;
    }

    public void injectMembers(T instance) {
        NuunProperty injectConfigAnnotation = null;
        injectConfigAnnotation = this.clonedAnno.annotationType() == NuunProperty.class ? this.field.getAnnotation(NuunProperty.class) : (NuunProperty)AssertUtils.annotationProxyOf(NuunProperty.class, (Annotation)this.clonedAnno);
        String configurationParameterName = injectConfigAnnotation.value();
        if (StringUtils.isEmpty((String)configurationParameterName)) {
            log.error("Value for annotation {} on field {} can not be null or empty.", this.clonedAnno.annotationType(), (Object)this.field.toGenericString());
            throw new PluginException("Value for annotation %s on field %s can not be null or empty.", new Object[]{this.clonedAnno.annotationType(), this.field.toGenericString()});
        }
    }
}

