/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.internal;

import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.predicates.ClassAnnotatedWith;
import io.nuun.kernel.core.AbstractPlugin;
import io.nuun.kernel.tests.internal.NuunITModule;
import io.nuun.kernel.tests.it.NuunITRunner;
import io.nuun.kernel.tests.it.annotations.ITBind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.runner.RunWith;

public class NuunITPlugin
extends AbstractPlugin {
    private Collection<Class<?>> integrationTestsClass;
    private final Predicate<Class<?>> iTSpecs = new ClassAnnotatedWith(RunWith.class).or((Predicate)new ClassAnnotatedWith(ITBind.class));

    public String name() {
        return "nuun-kernel-tests-plugin";
    }

    public InitState init(InitContext initContext) {
        Map scannedTypesByPredicate = initContext.scannedTypesByPredicate();
        Collection iTClassCandidates = (Collection)scannedTypesByPredicate.get(this.iTSpecs);
        if (iTClassCandidates != null && !iTClassCandidates.isEmpty()) {
            this.integrationTestsClass = new ArrayList();
            for (Class itCandidate : iTClassCandidates) {
                if ((itCandidate.getAnnotation(RunWith.class) == null || !NuunITRunner.class.isAssignableFrom(itCandidate.getAnnotation(RunWith.class).value())) && itCandidate.getAnnotation(ITBind.class) == null) continue;
                this.integrationTestsClass.add(itCandidate);
            }
        }
        return InitState.INITIALIZED;
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return this.classpathScanRequestBuilder().predicate(this.iTSpecs).build();
    }

    public Object nativeUnitModule() {
        return new NuunITModule(this.integrationTestsClass);
    }
}

