/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import com.google.common.base.Joiner;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.vfs.Vfs;

public class MetadataAdapterInMemory
implements MetadataAdapter<Class<?>, Field, Method> {
    public String getClassName(Class<?> cls) {
        return cls.getName();
    }

    public String getSuperclassName(Class<?> cls) {
        return cls.getSuperclass().getName();
    }

    public List<String> getInterfacesNames(Class<?> cls) {
        ArrayList<String> itfNames = new ArrayList<String>();
        for (Class<?> c : cls.getInterfaces()) {
            itfNames.add(c.getName());
        }
        return itfNames;
    }

    public List<Field> getFields(Class<?> cls) {
        ArrayList<Field> fl = new ArrayList<Field>();
        for (Field f : cls.getDeclaredFields()) {
            fl.add(f);
        }
        return fl;
    }

    public List<Method> getMethods(Class<?> cls) {
        ArrayList<Method> fm = new ArrayList<Method>();
        for (Method f : cls.getDeclaredMethods()) {
            fm.add(f);
        }
        return fm;
    }

    public String getMethodName(Method method) {
        return method.getName();
    }

    public List<String> getParameterNames(Method method) {
        ArrayList<String> parNames = new ArrayList<String>();
        int i = 0;
        for (Class<?> c : method.getParameterTypes()) {
            parNames.add("" + i);
            ++i;
        }
        return parNames;
    }

    public List<String> getClassAnnotationNames(Class<?> aClass) {
        ArrayList<String> fm = new ArrayList<String>();
        for (Annotation anno : aClass.getAnnotations()) {
            fm.add(anno.annotationType().getName());
        }
        return fm;
    }

    public List<String> getFieldAnnotationNames(Field field) {
        ArrayList<String> fm = new ArrayList<String>();
        for (Annotation anno : field.getAnnotations()) {
            fm.add(anno.annotationType().getName());
        }
        return fm;
    }

    public List<String> getMethodAnnotationNames(Method method) {
        ArrayList<String> fm = new ArrayList<String>();
        for (Annotation anno : method.getAnnotations()) {
            fm.add(anno.annotationType().getName());
        }
        return fm;
    }

    public List<String> getParameterAnnotationNames(Method method, int parameterIndex) {
        ArrayList<String> fm = new ArrayList<String>();
        if (parameterIndex < method.getParameterAnnotations().length) {
            for (Annotation anno : method.getAnnotations()) {
                fm.add(anno.annotationType().getName());
            }
        }
        return fm;
    }

    public String getReturnTypeName(Method method) {
        String name = null;
        Class<?> returnType = method.getReturnType();
        if (returnType != null) {
            name = returnType.getName();
        }
        return name;
    }

    public String getFieldName(Field field) {
        if (field != null) {
            return field.getName();
        }
        return null;
    }

    public Class<?> getOfCreateClassObject(Vfs.File file) throws Exception {
        if (file instanceof InMemoryClass) {
            InMemoryClass imf = (InMemoryClass)file;
            return (Class)imf.getContent();
        }
        return null;
    }

    public String getMethodModifier(Method method) {
        int accessFlags = method.getModifiers();
        return Modifier.isPrivate(accessFlags) ? "private" : (Modifier.isProtected(accessFlags) ? "protected" : (Modifier.isPublic(accessFlags) ? "public" : ""));
    }

    public String getMethodKey(Class<?> cls, Method method) {
        return method.getName() + "(" + Joiner.on((String)", ").join(this.getParameterNames(method)) + ")";
    }

    public String getMethodFullKey(Class<?> cls, Method method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    public boolean isPublic(Object o) {
        Integer accessFlag = o instanceof Class ? ((Class)o).getModifiers() : (o instanceof Field ? ((Field)o).getModifiers() : (o instanceof Method ? Integer.valueOf(((Method)o).getModifiers()) : null).intValue());
        return Modifier.isPublic(accessFlag);
    }

    public boolean acceptsInput(String file) {
        return true;
    }
}

