/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.inmemory;

import io.nuun.kernel.api.inmemory.Classpath;
import io.nuun.kernel.api.inmemory.ClasspathAbstractContainer;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathScannerDisk;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryFactory;
import io.nuun.kernel.core.internal.scanner.inmemory.MetadataAdapterInMemory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.util.ConfigurationBuilder;

public class ClasspathScannerInMemory
extends ClasspathScannerDisk {
    private final Classpath classpath;
    private final Set<URL> urls = new HashSet<URL>();

    public ClasspathScannerInMemory(Classpath classpath, int coreCount, String ... packageRoot) {
        super(null, null, coreCount, packageRoot);
        this.classpath = classpath;
        this.actualInitReflections();
    }

    private void actualInitReflections() {
        ConfigurationBuilder configurationBuilder = this.configurationBuilder().setScanners(this.getScanners()).setMetadataAdapter((MetadataAdapter)new MetadataAdapterInMemory());
        InMemoryFactory factory = new InMemoryFactory();
        for (ClasspathAbstractContainer i : this.classpath.entries()) {
            String name = i.name();
            try {
                configurationBuilder.addUrls(new URL[]{factory.createInMemoryResource(name)});
            }
            catch (MalformedURLException e) {
                throw new KernelException("Malformed URL Exception", e);
            }
        }
        this.urls.addAll(configurationBuilder.getUrls());
        this.reflections = new Reflections((Configuration)configurationBuilder);
    }

    @Override
    public Set<URL> getUrls() {
        return this.urls;
    }

    @Override
    protected void initializeReflections() {
    }
}

