/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner.disk;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.nuun.kernel.core.internal.scanner.AbstractClasspathScanner;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathStrategy;
import io.nuun.kernel.core.internal.utils.AssertUtils;
import io.nuun.kernel.core.internal.utils.NuunReflectionUtils;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScannerDisk
extends AbstractClasspathScanner {
    private final Logger logger = LoggerFactory.getLogger(ClasspathScannerDisk.class);
    private final List<String> packageRoots = new LinkedList<String>();
    private final ClasspathStrategy classpathStrategy;
    private final Set<URL> additionalClasspath;
    private final int coreCount;
    private Set<URL> urls;
    protected Reflections reflections;

    public ClasspathScannerDisk(ClasspathStrategy classpathStrategy, Set<URL> additionalClasspath, int coreCount, String ... packageRoots) {
        this(classpathStrategy, true, additionalClasspath, coreCount, packageRoots);
    }

    public ClasspathScannerDisk(ClasspathStrategy classpathStrategy, boolean reachAbstractClass, Set<URL> additionalClasspath, int coreCount, String ... packageRoots) {
        super(reachAbstractClass);
        Collections.addAll(this.packageRoots, packageRoots);
        this.classpathStrategy = classpathStrategy;
        this.additionalClasspath = additionalClasspath;
        this.coreCount = coreCount;
        this.initializeReflections();
    }

    protected void initializeReflections() {
        ConfigurationBuilder configurationBuilder = this.configurationBuilder().addUrls(this.findClasspathUrls()).setScanners(this.getScanners());
        this.reflections = new Reflections((Configuration)configurationBuilder);
    }

    protected ConfigurationBuilder configurationBuilder() {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        if (this.coreCount > 1) {
            cb.setExecutorService(Executors.newFixedThreadPool(this.coreCount));
        }
        FilterBuilder fb = new FilterBuilder();
        for (String packageRoot : this.packageRoots) {
            fb.include(FilterBuilder.prefix((String)packageRoot));
        }
        cb.filterInputsBy((com.google.common.base.Predicate)fb);
        return cb;
    }

    private Set<URL> findClasspathUrls() {
        if (this.urls == null) {
            this.urls = new HashSet<URL>();
            switch (this.classpathStrategy.getStrategy()) {
                case SYSTEM: {
                    this.urls.addAll(ClasspathHelper.forJavaClassPath());
                    break;
                }
                case CLASSLOADER: {
                    this.urls.addAll(ClasspathHelper.forClassLoader());
                    break;
                }
                case ALL: {
                    this.urls.addAll(ClasspathHelper.forJavaClassPath());
                    this.urls.addAll(ClasspathHelper.forClassLoader());
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported classpath strategy " + this.classpathStrategy.toString());
                }
            }
            if (this.classpathStrategy.isAdditional() && this.additionalClasspath != null) {
                this.urls.addAll(this.additionalClasspath);
            }
        }
        this.urls.addAll(ClasspathHelper.forManifest(this.urls));
        return this.urls;
    }

    @Override
    public Set<URL> getUrls() {
        return Collections.unmodifiableSet(this.urls);
    }

    @Override
    public Collection<Class<?>> scanTypes(Predicate<Class<?>> predicate) {
        Store store = this.reflections.getStore();
        Multimap multimap = store.get(TypeElementsScanner.class.getSimpleName());
        Set types = multimap.keySet();
        HashSet filteredTypes = new HashSet();
        for (Class candidate : NuunReflectionUtils.forNames(types)) {
            boolean test;
            try {
                test = predicate.test(candidate);
            }
            catch (Throwable t) {
                this.logger.debug("Unable to test predicate {} for candidate {}, ignoring it", new Object[]{predicate, candidate, t});
                test = false;
            }
            if (!test) continue;
            filteredTypes.add(candidate);
        }
        return this.postTreatment(filteredTypes);
    }

    @Override
    public Collection<Class<?>> scanTypesAnnotatedBy(Class<? extends Annotation> annotationType) {
        return this.postTreatment(this.reflections.getTypesAnnotatedWith(annotationType));
    }

    @Override
    public Collection<Class<?>> scanTypes(String typeRegex) {
        Store store = this.reflections.getStore();
        Multimap multimap = store.get(TypeElementsScanner.class.getSimpleName());
        HashSet<String> collectionOfString = new HashSet<String>();
        for (String loopKey : multimap.keySet()) {
            if (!loopKey.matches(typeRegex)) continue;
            collectionOfString.add(loopKey);
        }
        return this.postTreatment(NuunReflectionUtils.forNames(collectionOfString));
    }

    @Override
    public Collection<Class<?>> scanTypesAnnotatedBy(String annotationTypeRegex) {
        Store store = this.reflections.getStore();
        Multimap multimap = store.get(TypeAnnotationsScanner.class.getSimpleName());
        ArrayList<String> key = new ArrayList<String>();
        for (String loopKey : multimap.keySet()) {
            if (!loopKey.matches(annotationTypeRegex)) continue;
            key.add(loopKey);
        }
        HashSet typesAnnotatedWith = new HashSet();
        for (String k : key) {
            Collection collectionOfString = multimap.get((Object)k);
            typesAnnotatedWith.addAll(NuunReflectionUtils.forNames(collectionOfString));
        }
        return this.postTreatment(typesAnnotatedWith);
    }

    @Override
    public Collection<Class<?>> scanTypesMetaAnnotated(Class<? extends Annotation> annotationType) {
        Multimap multimap = this.reflections.getStore().get(TypeElementsScanner.class.getSimpleName());
        HashSet typesAnnotatedWith = Sets.newHashSet();
        for (String className : multimap.keys()) {
            Class<?> aClass = NuunReflectionUtils.forNameSilent(className);
            if (annotationType == null || aClass == null || !AssertUtils.hasAnnotationDeep(aClass, annotationType) || aClass.isAnnotation()) continue;
            typesAnnotatedWith.add(aClass);
        }
        return this.postTreatment(typesAnnotatedWith);
    }

    @Override
    public Collection<Class<?>> scanTypesMetaAnnotated(String metaAnnotationRegex) {
        Multimap multimap = this.reflections.getStore().get(TypeElementsScanner.class.getSimpleName());
        HashSet typesAnnotatedWith = Sets.newHashSet();
        for (String className : multimap.keys()) {
            Class<?> aClass = NuunReflectionUtils.forNameSilent(className);
            if (metaAnnotationRegex == null || aClass == null || !AssertUtils.hasAnnotationDeepRegex(aClass, metaAnnotationRegex) || aClass.isAnnotation()) continue;
            typesAnnotatedWith.add(aClass);
        }
        return this.postTreatment(typesAnnotatedWith);
    }

    @Override
    public Collection<Class<?>> scanSubTypesOf(Class<?> subType) {
        return this.postTreatment(this.reflections.getSubTypesOf(subType));
    }

    @Override
    public Collection<Class<?>> scanSubTypesOf(String subTypeName) {
        Store store = this.reflections.getStore();
        Multimap multimap = store.get(TypeElementsScanner.class.getSimpleName());
        HashSet<String> types = new HashSet<String>();
        for (String loopKey : multimap.keySet()) {
            if (!loopKey.matches(subTypeName)) continue;
            types.add(loopKey);
        }
        HashSet finalClasses = new HashSet();
        for (Class subType : NuunReflectionUtils.forNames(types)) {
            finalClasses.addAll(this.postTreatment(this.reflections.getSubTypesOf(subType)));
        }
        return finalClasses;
    }

    @Override
    public Set<String> scanResources(String pattern) {
        return this.reflections.getResources(Pattern.compile(pattern));
    }

    protected Scanner[] getScanners() {
        return new Scanner[]{this.buildTypeElementsScanner(), new SubTypesScanner(), new TypeAnnotationsScanner(), new ResourcesScanner()};
    }

    private TypeElementsScanner buildTypeElementsScanner() {
        return new TypeElementsScanner().includeFields(false).includeMethods(false).includeAnnotations(false);
    }
}

