/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import io.nuun.kernel.core.internal.scanner.IgnorePredicate;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryUrlType;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.reflections.vfs.Vfs;

public abstract class AbstractClasspathScanner
implements ClasspathScanner {
    private final boolean reachAbstractClass;

    public AbstractClasspathScanner(boolean reachAbstractClass) {
        this.reachAbstractClass = reachAbstractClass;
    }

    protected Collection<Class<?>> postTreatment(@Nullable Collection<Class<?>> set) {
        if (set == null) {
            return Lists.newArrayList();
        }
        return Collections2.filter(set, (Predicate)new IgnorePredicate(this.reachAbstractClass));
    }

    static {
        Vfs.setDefaultURLTypes(Arrays.asList(new InMemoryUrlType(), Vfs.DefaultUrlTypes.jarFile, Vfs.DefaultUrlTypes.jarUrl, Vfs.DefaultUrlTypes.directory, Vfs.DefaultUrlTypes.jarInputStream));
    }
}

