/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.injection;

import com.google.inject.AbstractModule;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.core.internal.ContextInternal;
import io.nuun.kernel.core.internal.RequestHandler;
import io.nuun.kernel.core.internal.injection.Installer;
import io.nuun.kernel.core.internal.injection.InstallerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KernelGuiceModuleInternal
extends AbstractModule {
    private final RequestHandler requestHandler;
    private boolean overriding = false;

    public KernelGuiceModuleInternal(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public KernelGuiceModuleInternal overriding() {
        this.overriding = true;
        return this;
    }

    protected final void configure() {
        this.binder().requireExplicitBindings();
        this.bind(Context.class).to(ContextInternal.class);
        this.installModuleAndClassesInOrder();
    }

    private void installModuleAndClassesInOrder() {
        List<Installer> installers = this.getComparableConcerns();
        Collections.sort(installers, Collections.reverseOrder());
        for (Installer installer : installers) {
            installer.install(this.binder());
        }
    }

    private List<Installer> getComparableConcerns() {
        ArrayList<Installer> installers = new ArrayList<Installer>();
        InstallerFactory installerFactory = new InstallerFactory(this.requestHandler.getClassesWithScopes());
        if (!this.overriding) {
            installers.addAll(installerFactory.createFromClasses(this.requestHandler.getClassesToBind()));
            installers.addAll(installerFactory.createFromUnitModules(this.requestHandler.getModules()));
        } else {
            installers.addAll(installerFactory.createFromUnitModules(this.requestHandler.getOverridingModules()));
        }
        return installers;
    }
}

