/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.injection;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import io.nuun.kernel.core.internal.injection.Installer;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassInstaller
extends Installer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInstaller.class);
    private final Class<?> classToBind;
    private final Object scope;

    public ClassInstaller(Class<?> aClass) {
        this(aClass, null);
    }

    public ClassInstaller(Class<?> aClass, Object scope) {
        this.classToBind = aClass;
        this.scope = scope;
    }

    @Override
    protected Class<?> getOriginalClass() {
        return this.classToBind;
    }

    @Override
    protected void install(Binder binder) {
        if (!this.classToBind.isInterface() && !ReflectionUtils.withAnnotation(Nullable.class).apply(this.classToBind)) {
            if (this.scope == null) {
                LOGGER.trace("Binding {} with no scope.", (Object)this.classToBind.getName());
                binder.bind(this.classToBind);
            } else {
                LOGGER.trace("Binding {} in scope {}.", (Object)this.classToBind.getName(), (Object)this.scope.toString());
                binder.bind(this.classToBind).in((Scope)this.scope);
            }
        } else {
            LOGGER.trace("Binding {} to a provider of null.", (Object)this.classToBind.getName());
            Provider nullProvider = Providers.of(null);
            binder.bind(this.classToBind).toProvider(nullProvider);
        }
    }
}

