/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.plugin.request.KernelParamsRequest;
import io.nuun.kernel.api.plugin.request.KernelParamsRequestType;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.AliasMap;
import java.util.Collection;
import java.util.HashSet;

class MandatoryParamsAsserter {
    MandatoryParamsAsserter() {
    }

    void assertMandatoryParams(Plugin plugin, AliasMap kernelParams) {
        Collection requestedParams = plugin.kernelParamsRequests();
        Collection<String> mandatoryParams = this.filterMandatoryParams(requestedParams);
        if (!kernelParams.containsAllKeys(mandatoryParams)) {
            throw new KernelException("Plugin " + plugin.name() + " misses parameter/s : " + requestedParams.toString(), new Object[0]);
        }
    }

    private Collection<String> filterMandatoryParams(Collection<KernelParamsRequest> kernelParamsRequests) {
        HashSet<String> computedMandatoryParams = new HashSet<String>();
        for (KernelParamsRequest kernelParamsRequest : kernelParamsRequests) {
            if (kernelParamsRequest.requestType != KernelParamsRequestType.MANDATORY) continue;
            computedMandatoryParams.add(kernelParamsRequest.keyRequested);
        }
        return computedMandatoryParams;
    }
}

