/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.base.Strings;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import io.nuun.kernel.api.Kernel;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.config.DependencyInjectionMode;
import io.nuun.kernel.api.config.KernelOptions;
import io.nuun.kernel.api.di.GlobalModule;
import io.nuun.kernel.api.di.ObjectGraph;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.Round;
import io.nuun.kernel.api.plugin.RoundInternal;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.DependenciesAsserter;
import io.nuun.kernel.core.internal.DependencyProvider;
import io.nuun.kernel.core.internal.ExtensionManager;
import io.nuun.kernel.core.internal.FacetRegistry;
import io.nuun.kernel.core.internal.InitContextInternal;
import io.nuun.kernel.core.internal.KernelConfigurationInternal;
import io.nuun.kernel.core.internal.MandatoryParamsAsserter;
import io.nuun.kernel.core.internal.PluginRegistry;
import io.nuun.kernel.core.internal.PluginSortStrategy;
import io.nuun.kernel.core.internal.RequestHandler;
import io.nuun.kernel.core.internal.State;
import io.nuun.kernel.core.internal.injection.KernelGuiceModuleInternal;
import io.nuun.kernel.core.internal.injection.ModuleEmbedded;
import io.nuun.kernel.core.internal.injection.ModuleHandler;
import io.nuun.kernel.core.internal.injection.ObjectGraphEmbedded;
import io.nuun.kernel.spi.DependencyInjectionProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KernelCore
implements Kernel {
    private static AtomicInteger kernelIndex = new AtomicInteger();
    private final Logger logger;
    private final String name;
    private final KernelConfigurationInternal kernelConfig;
    private final ModuleHandler moduleHandler;
    private final RequestHandler requestHandler;
    private final PluginRegistry pluginRegistry = new PluginRegistry();
    private State state = State.NOT_INITIALIZED;
    private Injector mainInjector;
    private Module mainModule;
    private List<Plugin> orderedPlugins;
    private RoundInternal round;
    private ExtensionManager extensionManager;
    private DependencyProvider dependencyProvider;
    private KernelOptions options;

    KernelCore(KernelConfigurationInternal kernelConfigurationInternal) {
        this.name = "Kernel-" + kernelIndex.getAndIncrement();
        this.logger = LoggerFactory.getLogger((String)(KernelCore.class.getName() + ' ' + this.name()));
        this.kernelConfig = kernelConfigurationInternal;
        this.options = kernelConfigurationInternal.options();
        if (!((Boolean)this.options.get(KernelOptions.ENABLE_REFLECTION_LOGGER)).booleanValue()) {
            Reflections.log = null;
        }
        this.requestHandler = new RequestHandler(this.kernelConfig.kernelParams().toMap(), this.options);
        this.moduleHandler = new ModuleHandler(this.kernelConfig);
    }

    public synchronized void init() {
        if (this.isInitialized()) {
            throw new KernelException("Kernel is already initialized", new Object[0]);
        }
        this.preparePlugins();
        this.validateMandatoryParams();
        this.fetchPackageRootsFromConfiguration();
        this.extensionManager = new ExtensionManager(this.pluginRegistry.getPlugins(), Thread.currentThread().getContextClassLoader());
        this.extensionManager.initializing();
        this.executeInitializationRounds();
        this.createMainModule();
        this.state = State.INITIALIZED;
        this.extensionManager.initialized();
    }

    public void preparePlugins() {
        this.addPluginsToTheRegistry();
        FacetRegistry facetRegistry = new FacetRegistry(this.pluginRegistry.getPlugins());
        this.dependencyProvider = new DependencyProvider(this.pluginRegistry, facetRegistry);
        this.round = new RoundInternal();
        DependenciesAsserter dependenciesAsserter = new DependenciesAsserter(facetRegistry);
        for (Plugin plugin : this.pluginRegistry.getPlugins()) {
            plugin.provideRound((Round)this.round);
            dependenciesAsserter.assertDependencies(plugin);
            this.addAliasesToKernelParams(plugin);
            this.fetchGlobalParametersFrom(plugin);
            this.addPackageRootsToRequestHandler(plugin.pluginPackageRoot());
            this.addPackageRootsToRequestHandler(plugin.rootPackages());
        }
        this.sortPlugins(facetRegistry);
    }

    private void addPluginsToTheRegistry() {
        this.registerPluginsFromKernelConfiguration();
        if (((Boolean)this.options.get(KernelOptions.SCAN_PLUGIN)).booleanValue()) {
            this.registerPluginsFromScan();
        }
    }

    private void registerPluginsFromKernelConfiguration() {
        for (Plugin plugin : this.kernelConfig.getPlugins()) {
            this.pluginRegistry.add(plugin);
        }
        for (Class clazz : this.kernelConfig.getPluginClasses()) {
            this.pluginRegistry.add(clazz);
        }
    }

    private void registerPluginsFromScan() {
        for (Plugin plugin : ServiceLoader.load(Plugin.class, Thread.currentThread().getContextClassLoader())) {
            this.pluginRegistry.add(plugin);
        }
    }

    private void addAliasesToKernelParams(Plugin plugin) {
        for (Map.Entry entry : plugin.kernelParametersAliases().entrySet()) {
            String alias = (String)entry.getKey();
            String keyToAlias = (String)entry.getValue();
            this.logger.info("Adding alias parameter \"{}\" to key \"{}\".", (Object)keyToAlias, (Object)alias);
            this.kernelConfig.kernelParams().putAlias(alias, keyToAlias);
        }
    }

    private void fetchGlobalParametersFrom(Plugin plugin) {
        DependencyInjectionProvider iocProvider;
        plugin.provideContainerContext(this.kernelConfig.getContainerContext());
        Set computeAdditionalClasspathScan = plugin.computeAdditionalClasspathScan();
        if (computeAdditionalClasspathScan != null && computeAdditionalClasspathScan.size() > 0) {
            for (URL url : computeAdditionalClasspathScan) {
                if (url == null) continue;
                this.requestHandler.addClasspathToScan(url);
                this.logger.debug("Plugin {} add classpath to scan: {}", (Object)plugin.name(), (Object)url.toExternalForm());
            }
        }
        if ((iocProvider = plugin.dependencyInjectionProvider()) != null) {
            this.moduleHandler.addDependencyInjectionProvider(iocProvider);
        }
    }

    private void sortPlugins(FacetRegistry facetRegistry) {
        ArrayList<Plugin> unOrderedPlugins = new ArrayList<Plugin>(this.pluginRegistry.getPlugins());
        this.logger.trace("unordered plugins: ({}) {}", (Object)unOrderedPlugins.size(), unOrderedPlugins);
        this.orderedPlugins = new PluginSortStrategy(facetRegistry, unOrderedPlugins).sortPlugins();
        this.logger.trace("ordered plugins: ({}) {}", (Object)this.orderedPlugins.size(), this.orderedPlugins);
    }

    private void fetchPackageRootsFromConfiguration() {
        if (this.kernelConfig.kernelParams().containsKey("nuun.root.package")) {
            String rootPackages = this.kernelConfig.kernelParams().get("nuun.root.package");
            this.addPackageRootsToRequestHandler(rootPackages);
        }
        for (String rootPackage : (List)this.options.get(KernelOptions.ROOT_PACKAGES)) {
            this.requestHandler.addRootPackage(rootPackage);
        }
    }

    private void addPackageRootsToRequestHandler(String pluginPackageRoots) {
        if (!Strings.isNullOrEmpty((String)pluginPackageRoots)) {
            for (String pack : pluginPackageRoots.split(",")) {
                this.logger.info("Adding {} as package root", (Object)pack);
                this.requestHandler.addRootPackage(pack.trim());
            }
        }
    }

    private void validateMandatoryParams() {
        MandatoryParamsAsserter mandatoryParamsAsserter = new MandatoryParamsAsserter();
        for (Plugin plugin : this.pluginRegistry.getPlugins()) {
            mandatoryParamsAsserter.assertMandatoryParams(plugin, this.kernelConfig.kernelParams());
        }
    }

    private void executeInitializationRounds() {
        this.logger.info("Initializing");
        List<Plugin> nonInitializedPlugins = this.orderedPlugins;
        while (this.allThePluginsAreNotInitialized(nonInitializedPlugins)) {
            this.logger.info("Round #{}", (Object)this.round.number());
            this.requestHandler.registerRequests(nonInitializedPlugins);
            this.requestHandler.executeRequests();
            nonInitializedPlugins = this.callPluginsInitMethod(nonInitializedPlugins, this.round.number());
            this.round.next();
        }
    }

    private boolean allThePluginsAreNotInitialized(List<Plugin> pluginsInTheRound) {
        return !pluginsInTheRound.isEmpty() && !this.round.isMax();
    }

    private List<Plugin> callPluginsInitMethod(List<Plugin> plugins, int round) {
        ArrayList<Plugin> nonInitializedPlugins = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            this.logger.info(" * {} plugin", (Object)plugin.name());
            InitContextInternal initContext = new InitContextInternal(this.kernelConfig.kernelParams().toMap(), this.requestHandler, round, this.dependencyProvider, plugin.getClass());
            if (plugin.init((InitContext)initContext) == InitState.INITIALIZED) continue;
            nonInitializedPlugins.add(plugin);
        }
        return nonInitializedPlugins;
    }

    private void createMainModule() {
        for (Plugin plugin : this.orderedPlugins) {
            this.moduleHandler.handleUnitModule(this.requestHandler, plugin);
            this.moduleHandler.handleOverridingUnitModule(this.requestHandler, plugin);
        }
        KernelGuiceModuleInternal kernelGuiceModuleInternal = new KernelGuiceModuleInternal(this.requestHandler);
        KernelGuiceModuleInternal internalKernelGuiceModuleOverriding = new KernelGuiceModuleInternal(this.requestHandler).overriding();
        this.mainModule = Modules.override((Module[])new Module[]{kernelGuiceModuleInternal}).with(new Module[]{internalKernelGuiceModuleOverriding});
    }

    public synchronized void start() {
        if (!this.isInitialized()) {
            throw new KernelException("Kernel is not initialized.", new Object[0]);
        }
        this.extensionManager.starting();
        this.createMainInjector();
        this.bindAndStartPlugins();
        this.state = State.STARTED;
        this.extensionManager.started();
    }

    private void createMainInjector() {
        Stage stage = this.convertInjectionModeToGuiceStage((DependencyInjectionMode)this.options.get(KernelOptions.DEPENDENCY_INJECTION_MODE));
        this.mainInjector = Guice.createInjector((Stage)stage, (Module[])new Module[]{this.mainModule});
    }

    private void bindAndStartPlugins() {
        Context context = (Context)this.mainInjector.getInstance(Context.class);
        for (Plugin plugin : this.orderedPlugins) {
            this.mainInjector.injectMembers((Object)plugin);
        }
        this.extensionManager.injected();
        for (Plugin plugin : this.orderedPlugins) {
            plugin.start(context);
        }
    }

    private Stage convertInjectionModeToGuiceStage(DependencyInjectionMode dependencyInjectionMode) {
        Stage stage;
        switch (dependencyInjectionMode) {
            case PRODUCTION: {
                stage = Stage.PRODUCTION;
                break;
            }
            case DEVELOPMENT: {
                stage = Stage.DEVELOPMENT;
                break;
            }
            case TOOL: {
                stage = Stage.TOOL;
                break;
            }
            default: {
                stage = Stage.PRODUCTION;
            }
        }
        return stage;
    }

    public void stop() {
        if (!this.isStarted()) {
            throw new KernelException("Kernel is not started.", new Object[0]);
        }
        this.extensionManager.stopping();
        this.stopPluginsInReverseOrder();
        this.extensionManager.stopped();
        this.state = State.STOPPED;
    }

    private void stopPluginsInReverseOrder() {
        ListIterator<Plugin> li = this.orderedPlugins.listIterator(this.orderedPlugins.size());
        while (li.hasPrevious()) {
            Plugin plugin = li.previous();
            plugin.stop();
        }
    }

    public String name() {
        return this.name;
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    public ObjectGraph objectGraph() {
        return new ObjectGraphEmbedded(this.mainInjector);
    }

    public UnitModule unitModule(Class<? extends Plugin> pluginClass) {
        return this.moduleHandler.getUnitModules().get(pluginClass);
    }

    public UnitModule overridingUnitModule(Class<? extends Plugin> pluginClass) {
        return this.moduleHandler.getOverridingUnitModules().get(pluginClass);
    }

    public UnitModule nonGuiceUnitModule(Class<? extends Plugin> plugin) {
        return this.moduleHandler.getNonGuiceUnitModules().get(plugin);
    }

    public UnitModule nonGuiceOverridingUnitModule(Class<? extends Plugin> plugin) {
        return this.moduleHandler.getNonGuiceOverridingUnitModules().get(plugin);
    }

    public GlobalModule globalModule() {
        return (GlobalModule)GlobalModule.class.cast(new ModuleEmbedded(this.mainModule));
    }

    public Map<String, Plugin> plugins() {
        return this.pluginRegistry.getPluginsByName();
    }

    public Set<URL> scannedURLs() {
        return this.requestHandler.getUrls();
    }
}

