/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.collect.ObjectArrays;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.DependencyInjectionMode;
import io.nuun.kernel.api.config.KernelConfiguration;
import io.nuun.kernel.api.config.KernelOption;
import io.nuun.kernel.api.config.KernelOptions;
import io.nuun.kernel.api.di.ModuleValidation;
import io.nuun.kernel.core.internal.AliasMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelConfigurationInternal
implements KernelConfiguration {
    private final Logger logger = LoggerFactory.getLogger(KernelConfiguration.class);
    private final AliasMap kernelParamsAndAlias = new AliasMap();
    private List<Class<? extends Plugin>> pluginsClass = new ArrayList<Class<? extends Plugin>>();
    private Plugin[] plugins = new Plugin[0];
    private List<ModuleValidation> validations = new ArrayList<ModuleValidation>();
    private Object containerContext;
    private KernelOptions options = new KernelOptions();

    public <T> KernelConfiguration option(KernelOption<T> option, T value) {
        this.options.set(option, value);
        return this;
    }

    public KernelOptions options() {
        return this.options;
    }

    public KernelConfiguration rootPackages(String ... rootPackages) {
        ((List)this.options.get(KernelOptions.ROOT_PACKAGES)).addAll(Arrays.asList(rootPackages));
        return this;
    }

    public KernelConfiguration param(String key, String value) {
        this.kernelParamsAndAlias.put(key, value);
        if (key.equals("nuun.root.package")) {
            ((List)this.options.get(KernelOptions.ROOT_PACKAGES)).add(value);
        }
        return this;
    }

    public KernelConfiguration params(String ... paramEntries) {
        if (this.isNotEvenNumber(paramEntries.length)) {
            throw new IllegalArgumentException("An even number of parameters was expected but found: " + Arrays.toString(paramEntries));
        }
        Iterator<String> it = Arrays.asList(paramEntries).iterator();
        while (it.hasNext()) {
            this.addParamKeyValue(it);
        }
        return this;
    }

    public boolean isNotEvenNumber(int number) {
        return number % 2 != 0;
    }

    private void addParamKeyValue(Iterator<String> it) {
        String key = it.next();
        String value = it.next();
        this.logger.debug("Adding {} = {} as param to kernel", (Object)key, (Object)value);
        this.param(key, value);
    }

    public AliasMap kernelParams() {
        return this.kernelParamsAndAlias;
    }

    public KernelConfiguration containerContext(Object containerContext) {
        this.containerContext = containerContext;
        return this;
    }

    public KernelConfiguration addPlugin(Class<? extends Plugin> pluginsClass) {
        Collections.addAll(this.pluginsClass, pluginsClass);
        return this;
    }

    public KernelConfiguration plugins(Class<? extends Plugin> ... pluginsClasses) {
        Collections.addAll(this.pluginsClass, pluginsClasses);
        return this;
    }

    public KernelConfiguration addPlugin(Plugin plugin) {
        this.plugins = (Plugin[])ObjectArrays.concat((Object)plugin, (Object[])this.plugins);
        return this;
    }

    public KernelConfiguration plugins(Plugin ... plugins) {
        this.plugins = (Plugin[])ObjectArrays.concat((Object[])this.plugins, (Object[])plugins, Plugin.class);
        return this;
    }

    public KernelConfiguration withoutSpiPluginsLoader() {
        this.options.set(KernelOptions.SCAN_PLUGIN, (Object)false);
        return this;
    }

    public KernelConfiguration withSpiPluginsLoader() {
        this.options.set(KernelOptions.SCAN_PLUGIN, (Object)true);
        return this;
    }

    public KernelConfiguration dependencyInjectionMode(DependencyInjectionMode dependencyInjectionMode) {
        this.options.set(KernelOptions.DEPENDENCY_INJECTION_MODE, (Object)dependencyInjectionMode);
        return this;
    }

    public KernelConfiguration classpathScanMode(ClasspathScanMode classpathScanMode) {
        this.options.set(KernelOptions.CLASSPATH_SCAN_MODE, (Object)classpathScanMode);
        return this;
    }

    public KernelConfiguration moduleValidation(ModuleValidation validation) {
        if (validation != null) {
            this.validations.add(validation);
        }
        return this;
    }

    public Object getContainerContext() {
        return this.containerContext;
    }

    public List<Class<? extends Plugin>> getPluginClasses() {
        return this.pluginsClass;
    }

    public Plugin[] getPlugins() {
        return this.plugins;
    }

    public List<ModuleValidation> getValidations() {
        return this.validations;
    }
}

