/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.core.internal.DependencyProvider;
import io.nuun.kernel.core.internal.RequestHandler;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class InitContextInternal
implements InitContext {
    private final Map<String, String> kernelParams;
    private final RequestHandler requestHandler;
    private final int roundNumber;
    private final DependencyProvider dependencyProvider;
    private final Class<? extends Plugin> pluginClass;

    public InitContextInternal(Map<String, String> kernelParams, RequestHandler requestHandler, int roundNumber, DependencyProvider dependencyProvider, Class<? extends Plugin> pluginClass) {
        this.kernelParams = kernelParams;
        this.requestHandler = requestHandler;
        this.roundNumber = roundNumber;
        this.dependencyProvider = dependencyProvider;
        this.pluginClass = pluginClass;
    }

    public int roundNumber() {
        return this.roundNumber;
    }

    public Map<String, String> kernelParams() {
        return this.kernelParams;
    }

    public String kernelParam(String key) {
        return this.kernelParams.get(key);
    }

    public Map<Class<?>, Collection<Class<?>>> scannedSubTypesByParentClass() {
        return this.requestHandler.scannedSubTypesByParentClass();
    }

    public Map<String, Collection<Class<?>>> scannedSubTypesByParentRegex() {
        return this.requestHandler.scannedSubTypesByParentRegex();
    }

    public Map<String, Collection<Class<?>>> scannedTypesByRegex() {
        return this.requestHandler.scannedTypesByRegex();
    }

    public Map<Predicate<Class<?>>, Collection<Class<?>>> scannedTypesByPredicate() {
        return this.requestHandler.scannedTypesByPredicate();
    }

    public Map<Class<? extends Annotation>, Collection<Class<?>>> scannedClassesByAnnotationClass() {
        return this.requestHandler.scannedClassesByAnnotationClass();
    }

    public Map<String, Collection<Class<?>>> scannedClassesByAnnotationRegex() {
        return this.requestHandler.scannedClassesByAnnotationRegex();
    }

    public Map<String, Collection<String>> mapPropertiesFilesByPrefix() {
        return this.requestHandler.getPropertiesFilesByPrefix();
    }

    public Map<String, Collection<String>> mapResourcesByRegex() {
        return this.requestHandler.getResourcesByRegex();
    }

    public Collection<Class<?>> classesToBind() {
        return this.requestHandler.getClassesToBind();
    }

    public List<UnitModule> moduleResults() {
        return this.requestHandler.getModules();
    }

    public List<UnitModule> moduleOverridingResults() {
        return this.requestHandler.getOverridingModules();
    }

    public Collection<String> propertiesFiles() {
        return this.requestHandler.getPropertyFiles();
    }

    public Collection<? extends Plugin> pluginsRequired() {
        return this.dependencyProvider.getRequiredPluginsOf(this.pluginClass);
    }

    public Collection<? extends Plugin> dependentPlugins() {
        return this.dependencyProvider.getDependentPluginsOf(this.pluginClass);
    }

    public List<?> dependencies() {
        return this.dependencyProvider.getDependenciesOf(this.pluginClass);
    }

    public <T> List<T> dependencies(Class<T> dependencyClass) {
        return this.dependencyProvider.getFacets(this.pluginClass, dependencyClass);
    }

    public <T> T dependency(Class<T> dependencyClass) {
        return this.dependencyProvider.getFacet(this.pluginClass, dependencyClass);
    }
}

