/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.FacetRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DependenciesAsserter {
    private final FacetRegistry facetRegistry;

    DependenciesAsserter(FacetRegistry facetRegistry) {
        this.facetRegistry = facetRegistry;
    }

    void assertDependencies(Plugin plugin) {
        Collection dependentPlugins;
        ArrayList expectedDependencies = new ArrayList();
        Collection requiredPlugins = plugin.requiredPlugins();
        if (requiredPlugins != null) {
            expectedDependencies.addAll(requiredPlugins);
        }
        if ((dependentPlugins = plugin.dependentPlugins()) != null) {
            expectedDependencies.addAll(dependentPlugins);
        }
        for (Class dependencyClass : expectedDependencies) {
            List facets = this.facetRegistry.getFacets(dependencyClass);
            if (!facets.isEmpty()) continue;
            throw new KernelException("Plugin %s misses the following dependency: %s", plugin.name(), dependencyClass.getCanonicalName());
        }
    }
}

