/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.core.KernelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AliasMap {
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();

    public String putAlias(String alias, String key) {
        if (this.aliases.containsKey(key)) {
            throw new IllegalArgumentException("The key \"" + key + "\" to alias is already present in the kernel parameters.");
        }
        return this.aliases.put(key, alias);
    }

    public String get(String key) {
        ArrayList<String> cache = new ArrayList<String>();
        return this.getWithAlias(key, cache);
    }

    private String getWithAlias(String key, List<String> cache) {
        if (cache.contains(key)) {
            throw new KernelException("Cycle detected in kernel parameter aliases.", new Object[0]);
        }
        cache.add(key);
        String alias = this.aliases.get(key);
        if (alias == null) {
            return this.params.get(key);
        }
        return this.getWithAlias(alias, cache);
    }

    public String put(String key, String value) {
        return this.params.put(key, value);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.params);
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            String alias = entry.getKey();
            String paramKey = entry.getValue();
            map.put(alias, this.get(paramKey));
        }
        return Collections.unmodifiableMap(map);
    }

    public boolean containsAllKeys(Collection<String> keys) {
        for (String key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(String key) {
        return this.aliases.containsKey(key) || this.params.containsKey(key);
    }
}

