/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.utils;

import com.google.common.collect.Lists;
import io.nuun.kernel.api.plugin.PluginException;
import java.util.Collection;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuunReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NuunReflectionUtils.class);

    public static <T> T instantiateOrFail(Class<?> aClass) {
        try {
            return (T)aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public static Class<?> forNameSilent(String candidate) {
        try {
            return Class.forName(candidate);
        }
        catch (Throwable e) {
            LOGGER.debug("Fail to load class {}: {}", (Object)candidate, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> Collection<Class<? extends T>> forNames(@Nullable Collection<String> names) {
        if (names == null || names.size() == 0) {
            return Lists.newArrayList();
        }
        return ReflectionUtils.forNames(names, (ClassLoader[])new ClassLoader[]{NuunReflectionUtils.class.getClassLoader()});
    }
}

