/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner;

import com.google.common.base.Predicate;
import io.nuun.kernel.api.annotations.Ignore;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;

class IgnorePredicate
implements Predicate<Class<?>> {
    private final boolean keepAbstractClasses;

    public IgnorePredicate(boolean keepAbstractClasses) {
        this.keepAbstractClasses = keepAbstractClasses;
    }

    public boolean apply(Class<?> clazz) {
        boolean keepClass = true;
        if (!this.keepAbstractClasses && this.isAbstractClass(clazz)) {
            keepClass = false;
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().equals(Ignore.class) && annotation.annotationType().getAnnotation(Ignore.class) == null) continue;
            keepClass = false;
            break;
        }
        return keepClass;
    }

    private boolean isAbstractClass(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface();
    }
}

