/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.scanner;

import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathScannerDisk;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathStrategy;
import io.nuun.kernel.core.internal.scanner.inmemory.ClasspathScannerInMemory;
import io.nuun.kernel.core.internal.scanner.inmemory.InMemoryClasspath;
import java.net.URL;
import java.util.List;
import java.util.Set;

public class ClasspathScannerFactory {
    private final ClasspathScanMode classpathScanMode;
    private final int coreCount;

    public ClasspathScannerFactory(ClasspathScanMode classpathScanMode, int coreCount) {
        this.classpathScanMode = classpathScanMode;
        this.coreCount = coreCount;
    }

    public ClasspathScanner create(ClasspathStrategy classpathStrategy, Set<URL> additionalClasspath, List<String> packageRoots) {
        String[] packageRootArray = new String[packageRoots.size()];
        packageRoots.toArray(packageRootArray);
        switch (this.classpathScanMode) {
            case NOMINAL: {
                return this.createNominal(classpathStrategy, additionalClasspath, packageRootArray);
            }
            case IN_MEMORY: {
                return this.createInMemory(packageRootArray);
            }
        }
        throw new UnsupportedOperationException();
    }

    private ClasspathScanner createNominal(ClasspathStrategy classpathStrategy, Set<URL> additionalClasspath, String ... packageRoot) {
        return new ClasspathScannerDisk(classpathStrategy, additionalClasspath, this.coreCount, packageRoot);
    }

    private ClasspathScanner createInMemory(String ... packageRoot) {
        InMemoryClasspath classpath = InMemoryClasspath.INSTANCE;
        return new ClasspathScannerInMemory(classpath, this.coreCount, packageRoot);
    }
}

