/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.injection;

import com.google.common.collect.Maps;
import com.google.inject.Module;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.di.ModuleValidation;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.KernelConfigurationInternal;
import io.nuun.kernel.core.internal.RequestHandler;
import io.nuun.kernel.core.internal.injection.ModuleEmbedded;
import io.nuun.kernel.spi.DependencyInjectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ModuleHandler {
    private final KernelConfigurationInternal kernelConfig;
    private final Collection<DependencyInjectionProvider> dependencyInjectionProviders = new ArrayList<DependencyInjectionProvider>();
    private final Map<Class<? extends Plugin>, UnitModule> unitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> overridingUnitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> nonGuiceUnitModules = Maps.newConcurrentMap();
    private final Map<Class<? extends Plugin>, UnitModule> nonGuiceOverridingUnitModules = Maps.newConcurrentMap();

    public ModuleHandler(KernelConfigurationInternal kernelConfig) {
        this.kernelConfig = kernelConfig;
    }

    public void addDependencyInjectionProvider(DependencyInjectionProvider dependencyInjectionProvider) {
        this.dependencyInjectionProviders.add(dependencyInjectionProvider);
    }

    public void handleUnitModule(RequestHandler requestHandler, Plugin plugin) {
        UnitModule unitModule = plugin.unitModule();
        if (unitModule == null || unitModule.nativeModule() == null) {
            return;
        }
        if (this.isNotGuiceModule(unitModule)) {
            this.nonGuiceUnitModules.put(plugin.getClass(), unitModule);
            unitModule = this.convertToNativeModule(plugin.name(), unitModule.nativeModule());
        }
        this.validateUnitModule(unitModule);
        requestHandler.addChildModule(ModuleEmbedded.wrap(Module.class.cast(unitModule.nativeModule())));
        this.unitModules.put(plugin.getClass(), unitModule);
    }

    private boolean isNotGuiceModule(UnitModule unitModule) {
        return !Module.class.isAssignableFrom(unitModule.nativeModule().getClass());
    }

    private UnitModule convertToNativeModule(String pluginName, Object nativeUnitModule) {
        DependencyInjectionProvider provider = this.findDependencyInjectionProvider(nativeUnitModule);
        if (provider != null) {
            return provider.convert(nativeUnitModule);
        }
        throw new KernelException("Missing DependencyInjectionProvider for module %s of plugin %s.", nativeUnitModule.getClass().getCanonicalName(), pluginName);
    }

    private DependencyInjectionProvider findDependencyInjectionProvider(Object nativeUnitModule) {
        for (DependencyInjectionProvider diProvider : this.dependencyInjectionProviders) {
            if (!diProvider.canHandle(nativeUnitModule.getClass())) continue;
            return diProvider;
        }
        return null;
    }

    private void validateUnitModule(UnitModule unitModule) {
        for (ModuleValidation validation : this.kernelConfig.getValidations()) {
            if (!validation.canHandle(unitModule.nativeModule().getClass())) continue;
            try {
                validation.validate(unitModule);
            }
            catch (Exception validationException) {
                throw new KernelException("Error when validating di definition " + unitModule, validationException);
            }
        }
    }

    public void handleOverridingUnitModule(RequestHandler requestHandler, Plugin plugin) {
        UnitModule unitModule = plugin.overridingUnitModule();
        if (unitModule == null || unitModule.nativeModule() == null) {
            return;
        }
        if (this.isNotGuiceModule(unitModule)) {
            this.nonGuiceOverridingUnitModules.put(plugin.getClass(), unitModule);
            unitModule = this.convertToNativeModule(plugin.name(), unitModule.nativeModule());
        }
        this.validateUnitModule(unitModule);
        requestHandler.addChildOverridingModule(ModuleEmbedded.wrap(Module.class.cast(unitModule.nativeModule())));
        this.overridingUnitModules.put(plugin.getClass(), unitModule);
    }

    public Map<Class<? extends Plugin>, UnitModule> getUnitModules() {
        return this.unitModules;
    }

    public Map<Class<? extends Plugin>, UnitModule> getOverridingUnitModules() {
        return this.overridingUnitModules;
    }

    public Map<Class<? extends Plugin>, UnitModule> getNonGuiceUnitModules() {
        return this.nonGuiceUnitModules;
    }

    public Map<Class<? extends Plugin>, UnitModule> getNonGuiceOverridingUnitModules() {
        return this.nonGuiceOverridingUnitModules;
    }
}

