/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.injection;

import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.core.internal.injection.ClassInstaller;
import io.nuun.kernel.core.internal.injection.Installer;
import io.nuun.kernel.core.internal.injection.UnitModuleInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class InstallerFactory {
    private final Map<Class<?>, Object> classesWithScopes;

    public InstallerFactory(Map<Class<?>, Object> classesWithScopes) {
        this.classesWithScopes = classesWithScopes;
    }

    List<Installer> createFromUnitModules(Collection<UnitModule> unitModules) {
        ArrayList<Installer> installers = new ArrayList<Installer>();
        for (UnitModule unitModule : unitModules) {
            installers.add(new UnitModuleInstaller(unitModule));
        }
        return installers;
    }

    List<Installer> createFromClasses(Collection<Class<?>> classes) {
        ArrayList<Installer> installerList = new ArrayList<Installer>();
        for (Class<?> aClass : classes) {
            installerList.add(new ClassInstaller(aClass, this.classesWithScopes.get(aClass)));
        }
        return installerList;
    }
}

