/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal.graph;

import io.nuun.kernel.core.internal.graph.Vertex;

public class Graph {
    private final int MAX_VERTS;
    private Vertex[] vertexList;
    private int[][] matrix;
    private int numVerts;
    private char[] sortedArray;

    public Graph(int maximumVertices) {
        this.MAX_VERTS = maximumVertices;
        this.vertexList = new Vertex[this.MAX_VERTS];
        this.matrix = new int[this.MAX_VERTS][this.MAX_VERTS];
        this.numVerts = 0;
        for (int i = 0; i < this.MAX_VERTS; ++i) {
            for (int k = 0; k < this.MAX_VERTS; ++k) {
                this.matrix[i][k] = 0;
            }
        }
        this.sortedArray = new char[this.MAX_VERTS];
    }

    public int addVertex(char lab) {
        this.vertexList[this.numVerts] = new Vertex(lab);
        return this.numVerts++;
    }

    public void addEdge(int start, int end) {
        this.matrix[start][end] = 1;
    }

    public void displayVertex(int v) {
        System.out.print(this.vertexList[v].label);
    }

    public char[] topologicalSort() {
        while (this.numVerts > 0) {
            int currentVertex = this.noSuccessors();
            if (currentVertex == -1) {
                return null;
            }
            this.sortedArray[this.numVerts - 1] = this.vertexList[currentVertex].label;
            this.deleteVertex(currentVertex);
        }
        return this.sortedArray;
    }

    public int noSuccessors() {
        for (int row = 0; row < this.numVerts; ++row) {
            boolean isEdge = false;
            for (int col = 0; col < this.numVerts; ++col) {
                if (this.matrix[row][col] <= 0) continue;
                isEdge = true;
                break;
            }
            if (isEdge) continue;
            return row;
        }
        return -1;
    }

    public void deleteVertex(int delVert) {
        if (delVert != this.numVerts - 1) {
            for (int j = delVert; j < this.numVerts - 1; ++j) {
                this.vertexList[j] = this.vertexList[j + 1];
            }
            for (int row = delVert; row < this.numVerts - 1; ++row) {
                this.moveRowUp(row, this.numVerts);
            }
            for (int col = delVert; col < this.numVerts - 1; ++col) {
                this.moveColLeft(col, this.numVerts - 1);
            }
        }
        --this.numVerts;
    }

    private void moveRowUp(int row, int length) {
        for (int col = 0; col < length; ++col) {
            this.matrix[row][col] = this.matrix[row + 1][col];
        }
    }

    private void moveColLeft(int col, int length) {
        for (int row = 0; row < length; ++row) {
            this.matrix[row][col] = this.matrix[row][col + 1];
        }
    }
}

