/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.request.RequestType;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class ScanResults {
    private final List<UnitModule> childModules = new ArrayList<UnitModule>();
    private final List<UnitModule> childOverridingModules = new ArrayList<UnitModule>();
    private final Set<Class<?>> classesToBind = new HashSet();
    private final Map<Class<?>, Collection<Class<?>>> mapSubTypes = new HashMap();
    private final Map<String, Collection<Class<?>>> mapSubTypesByName = new HashMap();
    private final Map<String, Collection<Class<?>>> mapTypesByName = new HashMap();
    private final Map<Predicate<Class<?>>, Collection<Class<?>>> mapTypesByPredicate = new HashMap();
    private final Map<Class<? extends Annotation>, Collection<Class<?>>> mapAnnotationTypes = new HashMap();
    private final Map<String, Collection<Class<?>>> mapAnnotationTypesByName = new HashMap();
    private final Map<String, Collection<String>> propertyFilesByPrefix = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> resourcesByRegex = new HashMap<String, Collection<String>>();
    private final Collection<String> propertyFiles = new HashSet<String>();
    private final Set<URL> urls = new HashSet<URL>();

    public Map<Class<?>, Collection<Class<?>>> scannedSubTypesByParentClass() {
        return Collections.unmodifiableMap(this.mapSubTypes);
    }

    public Map<String, Collection<Class<?>>> scannedSubTypesByParentRegex() {
        return Collections.unmodifiableMap(this.mapSubTypesByName);
    }

    public Map<String, Collection<Class<?>>> scannedTypesByRegex() {
        return Collections.unmodifiableMap(this.mapTypesByName);
    }

    public Map<Predicate<Class<?>>, Collection<Class<?>>> scannedTypesByPredicate() {
        return Collections.unmodifiableMap(this.mapTypesByPredicate);
    }

    public Map<Class<? extends Annotation>, Collection<Class<?>>> scannedClassesByAnnotationClass() {
        return Collections.unmodifiableMap(this.mapAnnotationTypes);
    }

    public Map<String, Collection<Class<?>>> scannedClassesByAnnotationRegex() {
        return Collections.unmodifiableMap(this.mapAnnotationTypesByName);
    }

    public Map<String, Collection<String>> getPropertiesFilesByPrefix() {
        return Collections.unmodifiableMap(this.propertyFilesByPrefix);
    }

    public Map<String, Collection<String>> getResourcesByRegex() {
        return Collections.unmodifiableMap(this.resourcesByRegex);
    }

    public Collection<Class<?>> getClassesToBind() {
        return Collections.unmodifiableCollection(this.classesToBind);
    }

    public List<UnitModule> getModules() {
        return Collections.unmodifiableList(this.childModules);
    }

    public List<UnitModule> getOverridingModules() {
        return Collections.unmodifiableList(this.childOverridingModules);
    }

    public Collection<String> getPropertyFiles() {
        return Collections.unmodifiableCollection(this.propertyFiles);
    }

    public Set<URL> getUrls() {
        return this.urls;
    }

    public void addUrls(Set<URL> urls) {
        this.urls.addAll(urls);
    }

    public void addClassesToBind(Collection<Class<?>> classesToBind) {
        this.classesToBind.addAll(classesToBind);
    }

    public void addChildModule(UnitModule module) {
        this.childModules.add(module);
    }

    public void addChildOverridingModule(UnitModule module) {
        this.childOverridingModules.add(module);
    }

    public void addSubtypes(Class<?> parentType, Collection<Class<?>> subtypes) {
        this.mapSubTypes.put(parentType, subtypes);
    }

    public void addSubTypesByName(String typeName, Collection<Class<?>> subtypes) {
        this.mapSubTypesByName.put(typeName, subtypes);
    }

    public void addTypesByName(String typeName, Collection<Class<?>> subtypes) {
        this.mapTypesByName.put(typeName, subtypes);
    }

    public void addTypesByPredicate(Predicate<Class<?>> classPredicate, Collection<Class<?>> subtypes) {
        this.mapTypesByPredicate.put(classPredicate, subtypes);
    }

    public void addAnnotationTypes(Class<? extends Annotation> annotationClass, Collection<Class<?>> subtypes) {
        this.mapAnnotationTypes.put(annotationClass, subtypes);
    }

    public void addAnnotationTypesByName(String annotationName, Collection<Class<?>> subtypes) {
        this.mapAnnotationTypesByName.put(annotationName, subtypes);
    }

    public void addResourcesByRegex(String regex, Set<String> urls) {
        this.resourcesByRegex.put(regex, urls);
    }

    public void addPropertyFiles(Set<String> propertyFiles) {
        propertyFiles.addAll(propertyFiles);
    }

    public void addPropertyFilesByPrefix(String prefix, Set<String> propertyFiles) {
        this.propertyFilesByPrefix.put(prefix, propertyFiles);
    }

    protected static class Key {
        private final RequestType type;
        private final Object key;

        public Key(RequestType type, Object key) {
            this.type = type;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return this.type == key1.type && Objects.equals(this.key, key1.key);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.key);
        }
    }
}

