/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.base.Strings;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.annotations.KernelModule;
import io.nuun.kernel.api.config.ClasspathScanMode;
import io.nuun.kernel.api.config.KernelOptions;
import io.nuun.kernel.api.plugin.request.BindingRequest;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.plugin.request.RequestType;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.ScanResults;
import io.nuun.kernel.core.internal.injection.ModuleEmbedded;
import io.nuun.kernel.core.internal.scanner.ClasspathScanner;
import io.nuun.kernel.core.internal.scanner.ClasspathScannerFactory;
import io.nuun.kernel.core.internal.scanner.disk.ClasspathStrategy;
import io.nuun.kernel.core.internal.utils.NuunReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler
extends ScanResults {
    private static final String SCAN_WHOLE_CLASSPATH_WARN_MESSAGE = "\n================================ WARNING ================================\n   You're actually scanning the WHOLE classpath , this can be time consuming.\n   Please update your application configuration, to narrow the scan to your application.\n\n 1) You can update /nuun.conf in the classpath with the following content\n\n          rootPackage = com.acme1, com.acme2\n\n   where com.acme1 and com.acme2 are your root packages.\n\n 2) You can programmatically use KernelConfiguration.rootPackage(\"com.acme1\" , \"com.acme2\")\n\n   Same as above\n\n 3) You can programmatically use KernelConfiguration.param(\"scan.warn.disable\" , \"true\")\n\n   This will disable the warning. It implies, you know what you are doing.\n\n========================================================================";
    private final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private final List<String> propertiesPrefix = new ArrayList<String>();
    private final List<Class<?>> parentTypesClassesToScan = new ArrayList();
    private final List<Class<?>> ancestorTypesClassesToScan = new ArrayList();
    private final List<Predicate<Class<?>>> predicatesToScan = new ArrayList();
    private final List<String> typesRegexToScan = new ArrayList<String>();
    private final List<String> resourcesRegexToScan = new ArrayList<String>();
    private final List<String> parentTypesRegexToScan = new ArrayList<String>();
    private final List<Class<? extends Annotation>> annotationTypesToScan = new ArrayList<Class<? extends Annotation>>();
    private final List<String> annotationRegexToScan = new ArrayList<String>();
    private final List<Class<?>> parentTypesClassesToBind = new ArrayList();
    private final List<Predicate<Class<?>>> predicatesToBind = new ArrayList();
    private final List<String> parentTypesRegexToBind = new ArrayList<String>();
    private final List<Class<? extends Annotation>> annotationTypesToBind = new ArrayList<Class<? extends Annotation>>();
    private final List<Class<? extends Annotation>> metaAnnotationTypesToBind = new ArrayList<Class<? extends Annotation>>();
    private final List<String> annotationRegexToBind = new ArrayList<String>();
    private final List<String> metaAnnotationRegexToBind = new ArrayList<String>();
    private final Map<Class<?>, Object> classesWithScopes = new HashMap();
    private final Map<ScanResults.Key, Object> mapOfScopes = new HashMap<ScanResults.Key, Object>();
    private final List<String> packageRoots;
    private Set<URL> additionalClasspathScan;
    private ClasspathStrategy classpathStrategy;
    private ClasspathScanner classpathScanner;
    private KernelOptions options;

    public RequestHandler(Map<String, String> kernelParams, KernelOptions options) {
        this.setClasspathStrategy(kernelParams);
        this.packageRoots = new LinkedList<String>();
        this.propertiesPrefix.add("nuun-");
        this.additionalClasspathScan = new HashSet<URL>();
        this.options = options;
    }

    private void setClasspathStrategy(Map<String, String> kernelParams) {
        String classpathStrategyName = kernelParams.get("nuun.classpath.strategy.name");
        String classpathStrategyAdditionalParam = kernelParams.get("nuun.classpath.strategy.additional");
        boolean additional = classpathStrategyAdditionalParam == null || Boolean.parseBoolean(classpathStrategyAdditionalParam);
        this.classpathStrategy = new ClasspathStrategy(classpathStrategyName, additional);
    }

    public void registerRequests(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.registerClasspathRequests(plugin);
            this.registerBindingRequests(plugin);
            this.registerPropertyPrefix(plugin);
        }
    }

    private void registerPropertyPrefix(Plugin plugin) {
        String pluginPropertiesPrefix = plugin.pluginPropertiesPrefix();
        if (!Strings.isNullOrEmpty((String)pluginPropertiesPrefix)) {
            this.addPropertiesPrefix(pluginPropertiesPrefix);
        }
    }

    private void registerClasspathRequests(Plugin plugin) {
        Collection classpathScanRequests = plugin.classpathScanRequests();
        if (classpathScanRequests != null && classpathScanRequests.size() > 0) {
            block9: for (ClasspathScanRequest request : classpathScanRequests) {
                switch (request.requestType) {
                    case ANNOTATION_TYPE: {
                        this.addAnnotationTypesToScan((Class)request.objectRequested);
                        continue block9;
                    }
                    case ANNOTATION_REGEX_MATCH: {
                        this.addAnnotationRegexesToScan((String)request.objectRequested);
                        continue block9;
                    }
                    case SUBTYPE_OF_BY_CLASS: {
                        this.addParentTypeClassToScan((Class)request.objectRequested);
                        continue block9;
                    }
                    case SUBTYPE_OF_BY_REGEX_MATCH: {
                        this.addParentTypeRegexesToScan((String)request.objectRequested);
                        continue block9;
                    }
                    case RESOURCES_REGEX_MATCH: {
                        this.addResourcesRegexToScan((String)request.objectRequested);
                        continue block9;
                    }
                    case TYPE_OF_BY_REGEX_MATCH: {
                        this.addTypeRegexesToScan((String)request.objectRequested);
                        continue block9;
                    }
                    case CLASS_PREDICATE: {
                        this.addPredicateToScan(request.classPredicate);
                        continue block9;
                    }
                }
                this.logger.warn("{} is not a ClasspathScanRequestType a o_O", (Object)request.requestType);
            }
        }
    }

    public void registerBindingRequests(Plugin plugin) {
        Collection bindingRequests = plugin.bindingRequests();
        if (bindingRequests != null && bindingRequests.size() > 0) {
            block9: for (BindingRequest request : bindingRequests) {
                switch (request.requestType) {
                    case ANNOTATION_TYPE: {
                        this.addAnnotationTypesToBind((Class)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case ANNOTATION_REGEX_MATCH: {
                        this.addAnnotationRegexesToBind((String)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case META_ANNOTATION_TYPE: {
                        this.addMetaAnnotationTypesToBind((Class)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case META_ANNOTATION_REGEX_MATCH: {
                        this.addMetaAnnotationRegexesToBind((String)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case SUBTYPE_OF_BY_CLASS: {
                        this.addParentTypeClassToBind((Class)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case SUBTYPE_OF_BY_REGEX_MATCH: {
                        this.addTypeRegexesToBind((String)request.requestedObject, request.requestedScope);
                        continue block9;
                    }
                    case CLASS_PREDICATE: {
                        this.addPredicateToBind(request.predicate, request.requestedScope);
                        continue block9;
                    }
                }
                this.logger.warn("{} is not a BindingRequestType o_O !", (Object)request.requestType);
            }
        }
    }

    public void executeRequests() {
        this.initScanner();
        this.scanKernelModules();
        this.scanClasses();
        this.scanClassesToBind();
        this.scanResources();
        this.scanPropertyFiles();
    }

    private void initScanner() {
        this.printWarnWhenScanningAllClasspath();
        ClasspathScannerFactory classpathScannerFactory = new ClasspathScannerFactory((ClasspathScanMode)this.options.get(KernelOptions.CLASSPATH_SCAN_MODE), (Integer)this.options.get(KernelOptions.THREAD_COUNT));
        this.classpathScanner = classpathScannerFactory.create(this.classpathStrategy, this.additionalClasspathScan, this.packageRoots);
        this.addUrls(this.classpathScanner.getUrls());
    }

    private void printWarnWhenScanningAllClasspath() {
        if (this.packageRoots.isEmpty() && ((Boolean)this.options.get(KernelOptions.PRINT_SCAN_WARN)).booleanValue()) {
            this.logger.warn(SCAN_WHOLE_CLASSPATH_WARN_MESSAGE);
        }
    }

    private void scanKernelModules() {
        Collection<Class<?>> scanResult = this.classpathScanner.scanTypesAnnotatedBy(KernelModule.class);
        for (Class<?> moduleClass : scanResult) {
            if (!this.isNotAbstract(moduleClass)) continue;
            ModuleEmbedded module = new ModuleEmbedded(NuunReflectionUtils.instantiateOrFail(moduleClass));
            if (this.isOverridingModule(moduleClass)) {
                this.addChildOverridingModule(module);
                continue;
            }
            this.addChildModule(module);
        }
    }

    private boolean isNotAbstract(Class<?> aClass) {
        return !Modifier.isAbstract(aClass.getModifiers());
    }

    private boolean isOverridingModule(Class<? extends Module> aClass) {
        KernelModule annotation = aClass.getAnnotation(KernelModule.class);
        return annotation != null && annotation.overriding();
    }

    private void scanClasses() {
        for (Class<?> clazz : this.parentTypesClassesToScan) {
            super.addSubtypes(clazz, this.classpathScanner.scanSubTypesOf(clazz));
        }
        for (String string : this.parentTypesRegexToScan) {
            super.addSubTypesByName(string, this.classpathScanner.scanSubTypesOf(string));
        }
        for (String string : this.typesRegexToScan) {
            super.addTypesByName(string, this.classpathScanner.scanTypes(string));
        }
        for (Predicate predicate : this.predicatesToScan) {
            super.addTypesByPredicate(predicate, this.classpathScanner.scanTypes(predicate));
        }
        for (Class clazz : this.annotationTypesToScan) {
            super.addAnnotationTypes(clazz, this.classpathScanner.scanTypesAnnotatedBy(clazz));
        }
        for (String string : this.annotationRegexToScan) {
            super.addAnnotationTypesByName(string, this.classpathScanner.scanTypesAnnotatedBy(string));
        }
    }

    private void scanClassesToBind() {
        RequestType requestType;
        Collection<Class<?>> scanResult;
        for (Class<?> clazz : this.parentTypesClassesToBind) {
            scanResult = this.classpathScanner.scanSubTypesOf(clazz);
            requestType = RequestType.SUBTYPE_OF_BY_CLASS;
            this.addScopeToClasses(scanResult, this.scope(requestType, clazz), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (String string : this.parentTypesRegexToBind) {
            scanResult = this.classpathScanner.scanTypes(string);
            requestType = RequestType.SUBTYPE_OF_BY_REGEX_MATCH;
            this.addScopeToClasses(scanResult, this.scope(requestType, string), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (Predicate predicate : this.predicatesToBind) {
            scanResult = this.classpathScanner.scanTypes(predicate);
            requestType = RequestType.CLASS_PREDICATE;
            this.addScopeToClasses(scanResult, this.scope(requestType, predicate), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (Class clazz : this.annotationTypesToBind) {
            scanResult = this.classpathScanner.scanTypesAnnotatedBy(clazz);
            requestType = RequestType.ANNOTATION_TYPE;
            this.addScopeToClasses(scanResult, this.scope(requestType, clazz), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (String string : this.annotationRegexToBind) {
            scanResult = this.classpathScanner.scanTypesAnnotatedBy(string);
            requestType = RequestType.ANNOTATION_REGEX_MATCH;
            this.addScopeToClasses(scanResult, this.scope(requestType, string), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (Class clazz : this.metaAnnotationTypesToBind) {
            scanResult = this.classpathScanner.scanTypesMetaAnnotated(clazz);
            requestType = RequestType.META_ANNOTATION_TYPE;
            this.addScopeToClasses(scanResult, this.scope(requestType, clazz), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
        for (String string : this.metaAnnotationRegexToBind) {
            scanResult = this.classpathScanner.scanTypesMetaAnnotated(string);
            requestType = RequestType.META_ANNOTATION_REGEX_MATCH;
            this.addScopeToClasses(scanResult, this.scope(requestType, string), this.classesWithScopes);
            this.addClassesToBind(scanResult);
        }
    }

    private Object scope(RequestType requestType, Object criteria) {
        Object scope = this.mapOfScopes.get(this.key(requestType, criteria));
        if (null == scope) {
            scope = Scopes.NO_SCOPE;
        }
        return scope;
    }

    private void addScopeToClasses(Collection<Class<?>> classes, Object scope, Map<Class<?>, Object> inClassesWithScopes) {
        for (Class<?> aClass : classes) {
            if (!inClassesWithScopes.containsKey(aClass) && scope != null) {
                inClassesWithScopes.put(aClass, scope);
                continue;
            }
            Object insideScope = inClassesWithScopes.get(aClass);
            if (insideScope.equals(scope)) continue;
            String format = String.format("Class %s is already associated with scope %s but  %s", aClass.getName(), insideScope, scope);
            this.logger.error(format);
            throw new KernelException(format, new Object[0]);
        }
    }

    private void scanResources() {
        for (String regex : this.resourcesRegexToScan) {
            super.addResourcesByRegex(regex, this.classpathScanner.scanResources(regex));
        }
    }

    private void scanPropertyFiles() {
        super.addPropertyFiles(this.classpathScanner.scanResources(".*\\.properties"));
        for (String prefix : this.propertiesPrefix) {
            super.addPropertyFilesByPrefix(prefix, this.classpathScanner.scanResources(prefix + ".*\\.properties"));
        }
    }

    public void addClasspathToScan(URL path) {
        if (path != null) {
            this.additionalClasspathScan.add(path);
        }
    }

    public void addPropertiesPrefix(String prefix) {
        this.propertiesPrefix.add(prefix);
    }

    public void addRootPackage(String root) {
        this.packageRoots.add(root);
    }

    public void addParentTypeClassToScan(Class<?> type) {
        this.parentTypesClassesToScan.add(type);
    }

    public void addAncestorTypeClassToScan(Class<?> type) {
        this.ancestorTypesClassesToScan.add(type);
    }

    public void addResourcesRegexToScan(String regex) {
        this.resourcesRegexToScan.add(regex);
    }

    private ScanResults.Key key(RequestType type, Object key) {
        return new ScanResults.Key(type, key);
    }

    public void addParentTypeClassToBind(Class<?> type, Object scope) {
        this.updateScope(this.key(RequestType.SUBTYPE_OF_BY_CLASS, type), scope);
        this.parentTypesClassesToBind.add(type);
    }

    public void addTypeRegexesToScan(String type) {
        this.typesRegexToScan.add(type);
    }

    public void addPredicateToScan(Predicate<Class<?>> classPredicate) {
        this.predicatesToScan.add(classPredicate);
    }

    public void addParentTypeRegexesToScan(String type) {
        this.parentTypesRegexToScan.add(type);
    }

    public void addTypeRegexesToBind(String type, Object scope) {
        this.updateScope(this.key(RequestType.TYPE_OF_BY_REGEX_MATCH, type), scope);
        this.parentTypesRegexToBind.add(type);
    }

    private void updateScope(ScanResults.Key key, Object scope) {
        if (scope != null) {
            this.mapOfScopes.put(key, scope);
        } else {
            this.mapOfScopes.put(key, Scopes.NO_SCOPE);
        }
    }

    public void addPredicateToBind(Predicate<Class<?>> classPredicate, Object scope) {
        this.predicatesToBind.add(classPredicate);
        this.updateScope(this.key(RequestType.CLASS_PREDICATE, classPredicate), scope);
    }

    public void addAnnotationTypesToScan(Class<? extends Annotation> types) {
        this.annotationTypesToScan.add(types);
    }

    public void addAnnotationTypesToBind(Class<? extends Annotation> types, Object scope) {
        this.annotationTypesToBind.add(types);
        this.updateScope(this.key(RequestType.ANNOTATION_TYPE, types), scope);
    }

    public void addMetaAnnotationTypesToBind(Class<? extends Annotation> types, Object scope) {
        this.metaAnnotationTypesToBind.add(types);
        this.updateScope(this.key(RequestType.META_ANNOTATION_TYPE, types), scope);
    }

    public void addAnnotationRegexesToScan(String names) {
        this.annotationRegexToScan.add(names);
    }

    public void addAnnotationRegexesToBind(String names, Object scope) {
        this.annotationRegexToBind.add(names);
        this.updateScope(this.key(RequestType.ANNOTATION_REGEX_MATCH, names), scope);
    }

    public void addMetaAnnotationRegexesToBind(String names, Object scope) {
        this.metaAnnotationRegexToBind.add(names);
        this.updateScope(this.key(RequestType.META_ANNOTATION_REGEX_MATCH, names), scope);
    }

    public Map<Class<?>, Object> getClassesWithScopes() {
        return Collections.unmodifiableMap(this.classesWithScopes);
    }
}

