/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.FacetRegistry;
import io.nuun.kernel.core.internal.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PluginSortStrategy {
    private final FacetRegistry facetRegistry;
    private final List<Plugin> plugins;
    private Graph graph;
    private Vertices vertices;

    public PluginSortStrategy(FacetRegistry facetRegistry, List<Plugin> unOrderedPlugins) {
        this.facetRegistry = facetRegistry;
        this.plugins = unOrderedPlugins;
        this.graph = new Graph(this.plugins.size());
        this.vertices = new Vertices();
    }

    public List<Plugin> sortPlugins() {
        this.addVertices();
        this.addEdges();
        return this.sortGraph();
    }

    private void addVertices() {
        for (int i = 0; i < this.plugins.size(); i = (int)((short)(i + 1))) {
            char label = (char)i;
            this.vertices.addVertex(label, this.graph.addVertex(label), this.plugins.get(i));
        }
    }

    private void addEdges() {
        for (Plugin source : this.plugins) {
            this.addEdgesForRequiredPlugins(source);
            this.addEdgesForDependentPlugins(source);
        }
    }

    private ArrayList<Plugin> sortGraph() {
        char[] topologicalSort = this.graph.topologicalSort();
        if (topologicalSort == null) {
            throw new KernelException("Error when sorting plugins: either a Cycle in dependencies or another cause.", new Object[0]);
        }
        ArrayList<Plugin> sorted = new ArrayList<Plugin>();
        char[] cArray = topologicalSort;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character label = Character.valueOf(cArray[i]);
            sorted.add(this.vertices.getPlugin(label.charValue()));
        }
        return sorted;
    }

    private void addEdgesForRequiredPlugins(Plugin source) {
        for (Class requiredClass : source.requiredPlugins()) {
            for (Class<?> dependencyClass : this.getCompleteDependencies(requiredClass)) {
                this.graph.addEdge(this.vertices.getIndex(dependencyClass), this.vertices.getIndex(source.getClass()));
            }
        }
    }

    private void addEdgesForDependentPlugins(Plugin source) {
        for (Class dependentClass : source.dependentPlugins()) {
            for (Class<?> dependencyClass : this.getCompleteDependencies(dependentClass)) {
                this.graph.addEdge(this.vertices.getIndex(source.getClass()), this.vertices.getIndex(dependencyClass));
            }
        }
    }

    private List<Class<?>> getCompleteDependencies(Class<?> declaredDependency) {
        ArrayList dependencies = new ArrayList();
        if (!Plugin.class.isAssignableFrom(declaredDependency)) {
            List<?> facets = this.facetRegistry.getFacets(declaredDependency);
            for (Object facet : facets) {
                dependencies.add(facet.getClass());
            }
        } else {
            dependencies.add(declaredDependency);
        }
        return dependencies;
    }

    private static class Vertices {
        Map<Integer, Plugin> pluginsByIndex = new HashMap<Integer, Plugin>();
        Map<Character, Plugin> pluginsByLabel = new HashMap<Character, Plugin>();
        Map<Class<?>, Integer> indexByPluginClasses = new HashMap();

        private Vertices() {
        }

        public void addVertex(char label, int index, Plugin plugin) {
            this.pluginsByLabel.put(Character.valueOf(label), plugin);
            this.pluginsByIndex.put(index, plugin);
            this.indexByPluginClasses.put(plugin.getClass(), index);
        }

        public int getIndex(Class<?> pluginClass) {
            return this.indexByPluginClasses.get(pluginClass);
        }

        public Plugin getPlugin(char label) {
            return this.pluginsByLabel.get(Character.valueOf(label));
        }
    }
}

