/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.core.KernelException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class PluginRegistry {
    private static final String NAME_UNIQUENESS_ERROR = "The kernel contains two plugins with the same name (%s): %s, %s";
    private static final String TYPE_UNIQUENESS_ERROR = "The kernel contains two plugins of type ";
    private static final String NAME_VALIDATION_ERROR = "The plugin %s doesn't have a correct name. It should not be null or empty.";
    private final Map<Class<? extends Plugin>, Plugin> pluginsByClass = new HashMap<Class<? extends Plugin>, Plugin>();
    private final Map<String, Plugin> pluginsByName = new HashMap<String, Plugin>();

    PluginRegistry() {
    }

    void add(Class<? extends Plugin> pluginClass) {
        try {
            this.add(pluginClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new KernelException("Plugin %s can not be instantiated", pluginClass);
        }
        catch (IllegalAccessException e) {
            throw new KernelException("Plugin %s can not be instantiated", pluginClass);
        }
    }

    void add(Plugin plugin) {
        this.assertNameNotBlank(plugin);
        this.indexPluginByClass(plugin);
        this.indexPluginByName(plugin);
    }

    private void assertNameNotBlank(Plugin plugin) {
        String name = plugin.name();
        if (name == null || name.equals("")) {
            throw new KernelException(NAME_VALIDATION_ERROR, plugin.getClass().getCanonicalName());
        }
    }

    private void indexPluginByName(Plugin plugin) {
        Plugin alreadyExistingPlugin = this.pluginsByName.put(plugin.name(), plugin);
        if (alreadyExistingPlugin != null) {
            throw new KernelException(String.format(NAME_UNIQUENESS_ERROR, plugin.name(), plugin.getClass().getCanonicalName(), alreadyExistingPlugin.getClass().getCanonicalName()), new Object[0]);
        }
    }

    private void indexPluginByClass(Plugin plugin) {
        Plugin alreadyExistingPlugin = this.pluginsByClass.put(plugin.getClass(), plugin);
        if (alreadyExistingPlugin != null) {
            throw new KernelException(TYPE_UNIQUENESS_ERROR + plugin.getClass().getCanonicalName(), new Object[0]);
        }
    }

    Plugin get(Class<? extends Plugin> pluginClass) {
        return this.pluginsByClass.get(pluginClass);
    }

    Plugin get(String name) {
        return this.pluginsByName.get(name);
    }

    Collection<Plugin> getPlugins() {
        return this.pluginsByClass.values();
    }

    Collection<Class<? extends Plugin>> getPluginClasses() {
        return this.pluginsByClass.keySet();
    }

    public Map<String, Plugin> getPluginsByName() {
        return this.pluginsByName;
    }
}

