/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.annotations.Facet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class FacetRegistry {
    private final ListMultimap<Class<?>, Plugin> pluginsByFacet = ArrayListMultimap.create();
    private final Map<Class<?>, Plugin> pluginsByClass = new HashMap();

    FacetRegistry(Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            this.pluginsByClass.put(plugin.getClass(), plugin);
            this.collectFacets(plugin);
        }
    }

    private void collectFacets(Plugin plugin) {
        for (Class<?> anInterface : plugin.getClass().getInterfaces()) {
            if (!this.isFacet(anInterface)) continue;
            this.pluginsByFacet.put(anInterface, (Object)plugin);
        }
    }

    <T> T getFacet(@Nullable Class<T> facet) throws IllegalStateException {
        T plugin = null;
        if (facet != null) {
            List<T> plugins = this.getFacets(facet);
            if (plugins.size() > 1) {
                throw new IllegalStateException(String.format("One implementation was expected for the %s facet, but found: %s", facet.getSimpleName(), plugins.toString()));
            }
            if (plugins.size() == 1) {
                plugin = plugins.get(0);
            }
        }
        return plugin;
    }

    <T> List<T> getFacets(@Nullable Class<T> facet) {
        if (facet != null && Plugin.class.isAssignableFrom(facet)) {
            ArrayList<Plugin> ts = new ArrayList<Plugin>();
            Plugin plugin = this.pluginsByClass.get(facet);
            if (plugin != null) {
                ts.add(plugin);
            }
            return ts;
        }
        return this.pluginsByFacet.get(facet);
    }

    private boolean isFacet(Class<?> aClass) {
        return aClass.isAnnotationPresent(Facet.class);
    }
}

