/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.spi.KernelExtension;
import java.util.Collection;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.Set;

public class ExtensionManager {
    private final Collection<Plugin> fetchedPlugins;
    private final ClassLoader contextClassLoader;
    private final Multimap<KernelExtension<?>, Plugin> kernelExtensions = ArrayListMultimap.create();

    public ExtensionManager(Collection<Plugin> fetchedPlugins, ClassLoader contextClassLoader) {
        this.fetchedPlugins = fetchedPlugins;
        this.contextClassLoader = contextClassLoader;
        this.fetchExtensions();
    }

    private void fetchExtensions() {
        ServiceLoader<KernelExtension> kernelExtensionLoader = ServiceLoader.load(KernelExtension.class, this.contextClassLoader);
        HashMap<Class, KernelExtension> extensionMapping = new HashMap<Class, KernelExtension>();
        for (KernelExtension kernelExtension : kernelExtensionLoader) {
            Class extensionInterface = TypeToken.of(kernelExtension.getClass()).resolveType(KernelExtension.class.getTypeParameters()[0]).getRawType();
            extensionMapping.put(extensionInterface, kernelExtension);
        }
        for (Plugin plugin : this.fetchedPlugins) {
            for (Class<?> anInterface : plugin.getClass().getInterfaces()) {
                if (!extensionMapping.containsKey(anInterface)) continue;
                KernelExtension kernelExtension = (KernelExtension)extensionMapping.get(anInterface);
                this.kernelExtensions.put((Object)kernelExtension, (Object)plugin);
            }
        }
    }

    public void initializing() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            Collection plugins = this.kernelExtensions.get((Object)kernelExtension);
            kernelExtension.initializing(plugins);
        }
    }

    public void initialized() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.initialized(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public void starting() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.starting(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public void injected() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.injected(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public void started() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.started(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public void stopping() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.stopping(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public void stopped() {
        for (KernelExtension kernelExtension : this.kernelExtensions.keySet()) {
            kernelExtension.stopped(this.kernelExtensions.get((Object)kernelExtension));
        }
    }

    public Set<KernelExtension<?>> getExtensions() {
        return this.kernelExtensions.keySet();
    }
}

