/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core.internal;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.core.KernelException;
import io.nuun.kernel.core.internal.FacetRegistry;
import io.nuun.kernel.core.internal.PluginRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class DependencyProvider {
    private final PluginRegistry pluginRegistry;
    private final FacetRegistry facetRegistry;

    public DependencyProvider(PluginRegistry pluginRegistry, FacetRegistry facetRegistry) {
        this.pluginRegistry = pluginRegistry;
        this.facetRegistry = facetRegistry;
    }

    public List<Plugin> getDependenciesOf(Class<? extends Plugin> pluginClass) {
        return this.getDependenciesOf(pluginClass, DependencyType.ALL);
    }

    public List<Plugin> getRequiredPluginsOf(Class<? extends Plugin> pluginClass) {
        return this.getDependenciesOf(pluginClass, DependencyType.REQUIRED);
    }

    public List<Plugin> getDependentPluginsOf(Class<? extends Plugin> pluginClass) {
        return this.getDependenciesOf(pluginClass, DependencyType.DEPENDENT);
    }

    private List<Plugin> getDependenciesOf(Class<? extends Plugin> pluginClass, DependencyType dependencyType) {
        Plugin plugin = this.pluginRegistry.get(pluginClass);
        ArrayList<Plugin> dependencies = new ArrayList<Plugin>();
        if (plugin != null) {
            for (Class<?> requiredClass : this.getDependencyClasses(plugin, dependencyType)) {
                dependencies.addAll(this.facetRegistry.getFacets(requiredClass));
            }
        }
        return dependencies;
    }

    private Collection<Class<?>> getDependencyClasses(Plugin plugin, DependencyType dependencyType) {
        Collection requiredClasses = new ArrayList();
        if (dependencyType == DependencyType.REQUIRED) {
            requiredClasses = plugin.requiredPlugins();
        } else if (dependencyType == DependencyType.DEPENDENT) {
            requiredClasses = plugin.dependentPlugins();
        } else if (dependencyType == DependencyType.ALL) {
            requiredClasses = plugin.requiredPlugins();
            requiredClasses.addAll(plugin.dependentPlugins());
        }
        return requiredClasses;
    }

    public <T> List<T> getFacets(Class<? extends Plugin> pluginClass, Class<T> facet) {
        this.assertExplicitDependency(pluginClass, facet);
        return this.facetRegistry.getFacets(facet);
    }

    public <T> T getFacet(Class<? extends Plugin> pluginClass, Class<T> facet) {
        this.assertExplicitDependency(pluginClass, facet);
        return this.facetRegistry.getFacet(facet);
    }

    private <T> void assertExplicitDependency(Class<? extends Plugin> pluginClass, Class<T> facet) {
        Plugin plugin = this.pluginRegistry.get(pluginClass);
        if (!plugin.requiredPlugins().contains(facet) && !plugin.dependentPlugins().contains(facet)) {
            throw new KernelException("The plugin " + pluginClass.getCanonicalName() + " doesn't specify a dependency with " + facet.getCanonicalName(), new Object[0]);
        }
    }

    private static enum DependencyType {
        REQUIRED,
        DEPENDENT,
        ALL;

    }
}

