/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.core;

import io.nuun.kernel.api.Plugin;
import io.nuun.kernel.api.di.UnitModule;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.Round;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.BindingRequest;
import io.nuun.kernel.api.plugin.request.BindingRequestBuilder;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequestBuilder;
import io.nuun.kernel.api.plugin.request.KernelParamsRequest;
import io.nuun.kernel.api.plugin.request.KernelParamsRequestBuilder;
import io.nuun.kernel.api.plugin.request.builders.BindingRequestBuilderMain;
import io.nuun.kernel.core.internal.injection.ModuleEmbedded;
import io.nuun.kernel.spi.DependencyInjectionProvider;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractPlugin
implements Plugin {
    protected Context context = null;
    protected Object containerContext = null;
    protected Round round;

    public InitState init(InitContext initContext) {
        return InitState.INITIALIZED;
    }

    public void start(Context context) {
        this.context = context;
    }

    public void stop() {
    }

    protected KernelParamsRequestBuilder kernelParamsRequestBuilder() {
        return new KernelParamsRequestBuilder();
    }

    protected ClasspathScanRequestBuilder classpathScanRequestBuilder() {
        return new ClasspathScanRequestBuilder();
    }

    protected BindingRequestBuilderMain bindingRequestsBuilder() {
        return new BindingRequestBuilder();
    }

    public abstract String name();

    public String description() {
        return this.name() + " Nuun Based Plugin.";
    }

    public Collection<KernelParamsRequest> kernelParamsRequests() {
        return Collections.emptySet();
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return Collections.emptySet();
    }

    public Collection<BindingRequest> bindingRequests() {
        return Collections.emptySet();
    }

    public Collection<Class<?>> requiredPlugins() {
        return Collections.emptySet();
    }

    public Collection<Class<?>> dependentPlugins() {
        return Collections.emptySet();
    }

    public String pluginPropertiesPrefix() {
        return "";
    }

    public String pluginPackageRoot() {
        return "";
    }

    public String rootPackages() {
        return "";
    }

    public UnitModule unitModule() {
        return this.nativeUnitModule() != null ? new ModuleEmbedded(this.nativeUnitModule()) : null;
    }

    public Object nativeUnitModule() {
        return null;
    }

    public Object nativeOverridingUnitModule() {
        return null;
    }

    public UnitModule overridingUnitModule() {
        return this.nativeOverridingUnitModule() != null ? new ModuleEmbedded(this.nativeOverridingUnitModule()) : null;
    }

    public void provideContainerContext(Object containerContext) {
        this.containerContext = containerContext;
    }

    public Set<URL> computeAdditionalClasspathScan() {
        return Collections.emptySet();
    }

    public DependencyInjectionProvider dependencyInjectionProvider() {
        return null;
    }

    public void provideRound(Round round) {
        this.round = round;
    }

    public Map<String, String> kernelParametersAliases() {
        return new HashMap<String, String>();
    }

    protected UnitModule unitModule(Object module) {
        return new ModuleEmbedded(module);
    }
}

