/**
 * This file is part of Nuun IO Kernel Tests.
 *
 * Nuun IO Kernel Tests is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Nuun IO Kernel Tests is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Nuun IO Kernel Tests.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.nuun.kernel.tests.internal;

import java.util.Collection;

import com.google.inject.AbstractModule;

/**
 * @author epo.jemba{@literal @}kametic.com
 *
 */
public class NuunITModule extends AbstractModule
{

    private Collection<Class<?>> iTs;

    public NuunITModule (Collection<Class<?>> iTs) {
        this.iTs = iTs;
    }

    @Override
    protected void configure() {
        if(iTs!=null && !iTs.isEmpty()){
            for(Class<?> iT  : iTs){
                bind(iT);
            }
        }
    }

}
