/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.internal;

import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.context.InitContext;
import io.nuun.kernel.api.plugin.request.ClasspathScanRequest;
import io.nuun.kernel.core.AbstractPlugin;
import io.nuun.kernel.tests.internal.NuunITModule;
import io.nuun.kernel.tests.it.NuunITRunner;
import io.nuun.kernel.tests.it.annotations.ITBind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.junit.runner.RunWith;
import org.kametic.specifications.Specification;

public class NuunITPlugin
extends AbstractPlugin {
    private Collection<Class<?>> integrationTestsClass;
    private final Specification<Class<?>> iTSpecs = this.or(new Specification[]{this.classAnnotatedWith(RunWith.class), this.classAnnotatedWith(ITBind.class)});

    public String name() {
        return "nuun-kernel-tests-plugin";
    }

    public InitState init(InitContext initContext) {
        Map scannedTypesBySpecification = initContext.scannedTypesBySpecification();
        Collection iTClassCandidates = (Collection)scannedTypesBySpecification.get(this.iTSpecs);
        if (iTClassCandidates != null && !iTClassCandidates.isEmpty()) {
            this.integrationTestsClass = new ArrayList();
            for (Class itCandidate : iTClassCandidates) {
                if ((itCandidate.getAnnotation(RunWith.class) == null || !NuunITRunner.class.isAssignableFrom(itCandidate.getAnnotation(RunWith.class).value())) && itCandidate.getAnnotation(ITBind.class) == null) continue;
                this.integrationTestsClass.add(itCandidate);
            }
        }
        return InitState.INITIALIZED;
    }

    public Collection<ClasspathScanRequest> classpathScanRequests() {
        return this.classpathScanRequestBuilder().specification(this.iTSpecs).build();
    }

    public Object nativeUnitModule() {
        return new NuunITModule(this.integrationTestsClass);
    }
}

