/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.ut.assertor;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.util.Types;
import io.nuun.kernel.tests.internal.ElementMap;
import io.nuun.kernel.tests.internal.visitor.MapElementVisitor;
import io.nuun.kernel.tests.ut.assertor.ElementAssertor;
import io.nuun.kernel.tests.ut.assertor.ElementDelta;
import io.nuun.kernel.tests.ut.assertor.ModuleAssertor;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

public class ModuleDiff {
    private final Module actual;
    private final ElementMap<? extends ElementAssertor<? extends Element>> assertions;

    public ModuleDiff(Module actual, ModuleAssertor moduleAssertor) {
        this.actual = actual;
        this.assertions = moduleAssertor.assertions();
    }

    public ElementMap<ElementDelta> diff() {
        ElementMap<ElementDelta> delta = new ElementMap<ElementDelta>();
        ElementMap<Element> actualStore = this.visit(this.actual);
        for (Class keyClass : this.assertions.keys()) {
            Collection actualInstances = actualStore.get(keyClass);
            Collection elementAssertors = this.assertions.get(keyClass);
            if (actualInstances == null || elementAssertors == null) continue;
            for (ElementAssertor elementAssertor : elementAssertors) {
                int count = Collections2.filter((Collection)actualInstances, ElementPredicate.create(elementAssertor)).size();
                if (count == elementAssertor.expectedTimes()) continue;
                delta.put(keyClass, new ElementDelta(elementAssertor, count));
            }
        }
        return delta;
    }

    private ElementMap<Element> visit(Module candidate) {
        ElementMap<Element> elementMap = null;
        MapElementVisitor visitor = new MapElementVisitor();
        for (Element element : Elements.getElements((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{candidate})) {
            element.acceptVisitor((ElementVisitor)visitor);
        }
        elementMap = visitor.getStore();
        return elementMap;
    }

    static class ElementPredicate<EP extends ElementAssertor<C>, C extends Element>
    implements Predicate<C> {
        private EP elementAssertor;

        public ElementPredicate(EP elementAssertor) {
            this.elementAssertor = elementAssertor;
        }

        public boolean apply(C input) {
            return this.elementAssertor.asserts(input);
        }

        public static <A extends ElementAssertor<B>, B extends Element> ElementPredicate<A, B> create(ElementAssertor<?> elementAssertor) {
            Class elementClass = (Class)((ParameterizedType)elementAssertor.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Class candidateClass = (Class)TypeLiteral.get((Type)Types.newParameterizedType(ElementPredicate.class, (Type[])new Type[]{elementAssertor.getClass(), elementClass})).getType();
            try {
                Constructor constructor = candidateClass.getConstructor(elementAssertor.getClass());
                return (ElementPredicate)constructor.newInstance(elementAssertor);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

