/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.ut.assertor;

import com.google.inject.Key;
import com.google.inject.spi.Element;
import io.nuun.kernel.tests.internal.ElementMap;
import io.nuun.kernel.tests.internal.dsl.builder.AnnotatedBindingBuilderImpl;
import io.nuun.kernel.tests.internal.dsl.builder.LinkedBindingBuilderImpl;
import io.nuun.kernel.tests.internal.dsl.builder.TimedScopedBindingBuilderImpl;
import io.nuun.kernel.tests.internal.dsl.holder.GlobalHolder;
import io.nuun.kernel.tests.internal.dsl.holder.InjecteeHolder;
import io.nuun.kernel.tests.ut.assertor.ElementAssertor;
import io.nuun.kernel.tests.ut.assertor.ElementAssertorFactory;
import io.nuun.kernel.tests.ut.assertor.dsl.AnnotatedBindingBuilder;
import io.nuun.kernel.tests.ut.assertor.dsl.LinkedBindingBuilder;
import io.nuun.kernel.tests.ut.assertor.dsl.TimedScopedBindingBuilder;
import io.nuun.kernel.tests.ut.assertor.dsl.wildcard.Wildcard;
import java.util.ArrayList;
import java.util.List;

public abstract class ModuleAssertor {
    private ElementMap<ElementAssertor<? extends Element>> assertors = new ElementMap();
    private List<GlobalHolder> globalHolders = new ArrayList<GlobalHolder>();

    public ElementMap<? extends ElementAssertor<? extends Element>> assertions() {
        this.computeAssertors();
        return this.assertors;
    }

    private void computeAssertors() {
        this.assertors.clear();
        ElementAssertorFactory factory = new ElementAssertorFactory();
        for (GlobalHolder globalHolder : this.globalHolders) {
        }
    }

    protected <T> LinkedBindingBuilder<T> assertBind(Key<T> key) {
        GlobalHolder globalHolder = new GlobalHolder();
        this.globalHolders.add(globalHolder);
        globalHolder.as(InjecteeHolder.class).setInjecteeKey(key);
        return new LinkedBindingBuilderImpl(globalHolder);
    }

    protected <T> AnnotatedBindingBuilder<T> assertBind(Class<T> clss) {
        GlobalHolder globalHolder = new GlobalHolder();
        this.globalHolders.add(globalHolder);
        globalHolder.as(InjecteeHolder.class).setInjecteeClass(clss);
        return new AnnotatedBindingBuilderImpl(globalHolder);
    }

    protected TimedScopedBindingBuilder assertBind(Wildcard wildcard) {
        GlobalHolder globalHolder = new GlobalHolder();
        this.globalHolders.add(globalHolder);
        GlobalHolder injecteeHolder = globalHolder;
        injecteeHolder.setInjecteeWildcard(wildcard);
        return new TimedScopedBindingBuilderImpl(globalHolder);
    }

    public List<GlobalHolder> globalHolders() {
        return this.globalHolders;
    }

    public abstract void configure();
}

