/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.internal.visitor;

import com.google.common.collect.Multimap;
import com.google.inject.Binder;
import com.google.inject.Scope;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import java.lang.annotation.Annotation;

public class MapBindingScopingVisitor
implements BindingScopingVisitor<Void> {
    private Multimap<Class<? extends Element>, Object> store;

    MapBindingScopingVisitor(Multimap<Class<? extends Element>, Object> store) {
        this.store = store;
    }

    public Void visitEagerSingleton() {
        this.store.put(EagerSingleton.class, null);
        this.log("Eager Singleton ");
        return null;
    }

    public Void visitScope(Scope scope) {
        this.log("Scope " + scope);
        return null;
    }

    public Void visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
        this.log("Scope Annotation " + scopeAnnotation);
        return null;
    }

    public Void visitNoScoping() {
        this.log("No Scoping");
        return null;
    }

    private void log(Object element) {
        System.out.println("" + element);
    }

    public static class ScopeAnnotation
    extends ScopingElement {
        public final Class<? extends Annotation> scopeAnnotation;

        public ScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            this.scopeAnnotation = scopeAnnotation;
        }
    }

    public static class ScopeElement
    extends ScopingElement {
        public final Scope scope;

        public ScopeElement(Scope scope) {
            this.scope = scope;
        }
    }

    public static class NoScoping
    extends ScopingElement {
    }

    public static class EagerSingleton
    extends ScopingElement {
    }

    public static class ScopingElement
    implements Element {
        public Object getSource() {
            return null;
        }

        public <T> T acceptVisitor(ElementVisitor<T> visitor) {
            return null;
        }

        public void applyTo(Binder binder) {
        }
    }
}

