/*
 * Decompiled with CFR 0.152.
 */
package io.nuun.kernel.tests.it;

import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import io.nuun.kernel.api.Kernel;
import io.nuun.kernel.api.config.KernelConfiguration;
import io.nuun.kernel.core.NuunCore;
import io.nuun.kernel.tests.it.NuunITException;
import io.nuun.kernel.tests.it.annotations.Expect;
import io.nuun.kernel.tests.it.annotations.WithPlugins;
import io.nuun.kernel.tests.it.annotations.WithoutSpiPluginsLoader;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class NuunITRunner
extends BlockJUnit4ClassRunner {
    private Kernel kernel;
    private Class<?> expectedClass = null;

    public NuunITRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        this.kernel = this.initKernel();
        super.run(notifier);
        this.kernel.stop();
    }

    protected Object createTest() throws Exception {
        String message;
        boolean catchOccured = false;
        boolean expecting = this.withExpect();
        Throwable actualThrowable = null;
        Object test = null;
        try {
            test = ((Injector)this.kernel.objectGraph().as(Injector.class)).getInstance(this.getTestClass().getJavaClass());
        }
        catch (Throwable t) {
            if (t.getClass().equals(ProvisionException.class)) {
                t = t.getCause();
            }
            actualThrowable = t;
            if (t.getClass().equals(this.expectedClass)) {
                test = super.createTest();
            }
            catchOccured = true;
        }
        if (expecting && !catchOccured) {
            message = "EXPECTED_EXCEPTION_DID_NOT_OCCURED";
            message = message + "\n\tExpected class = " + this.expectedClass;
            message = message + "\n\tActual throwable = " + actualThrowable;
            NuunITException exception = new NuunITException(message, actualThrowable);
            throw exception;
        }
        if (!expecting && catchOccured) {
            message = "UNEXPECTED_EXCEPTION_OCCURED";
            message = message + "\n\tExpected class = " + this.expectedClass;
            message = message + "\n\tActual throwable = " + actualThrowable;
            NuunITException exception = new NuunITException(message, actualThrowable);
            throw exception;
        }
        return test;
    }

    private Kernel initKernel() {
        KernelConfiguration configuration = NuunCore.newKernelConfiguration();
        this.withoutSpiPluginsLoader(configuration);
        this.withPlugins(configuration);
        Kernel underTest = NuunCore.createKernel((KernelConfiguration)configuration);
        underTest.init();
        underTest.start();
        return underTest;
    }

    private void withPlugins(KernelConfiguration configuration) {
        WithPlugins annotation = this.getTestClass().getJavaClass().getAnnotation(WithPlugins.class);
        if (annotation != null) {
            configuration.plugins((Class[])annotation.value());
        }
    }

    private boolean withExpect() {
        Expect annotation = this.getTestClass().getJavaClass().getAnnotation(Expect.class);
        if (annotation != null) {
            this.expectedClass = annotation.value();
        }
        return this.expectedClass != null;
    }

    private void withoutSpiPluginsLoader(KernelConfiguration configuration) {
        if (this.getTestClass().getJavaClass().getAnnotation(WithoutSpiPluginsLoader.class) != null) {
            configuration.withoutSpiPluginsLoader();
        }
    }
}

